/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.core;

import com.github.fracpete.requests4j.core.AbstractResponse;
import java.io.IOException;
import java.io.OutputStream;

public class StreamResponse
extends AbstractResponse {
    protected OutputStream m_OutputStream;
    protected boolean m_CloseOnFinish;

    public StreamResponse(OutputStream outputStream) {
        this(outputStream, false);
    }

    public StreamResponse(OutputStream outputStream, boolean closeOnFinish) {
        this.m_OutputStream = outputStream;
        this.m_CloseOnFinish = closeOnFinish;
    }

    public OutputStream outputStream() {
        return this.m_OutputStream;
    }

    public boolean closeOnFinish() {
        return this.m_CloseOnFinish;
    }

    @Override
    public void appendBody(byte b) throws IOException {
        this.m_OutputStream.write(b);
    }

    @Override
    public void finishBody() throws IOException {
        this.m_OutputStream.flush();
        if (this.m_CloseOnFinish) {
            this.m_OutputStream.close();
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", closeOnFinish=" + this.closeOnFinish();
    }
}

