/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.form;

import com.github.fracpete.requests4j.form.AbstractParameter;
import com.github.fracpete.requests4j.form.StreamParameter;
import com.github.fracpete.requests4j.form.StringParameter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;
import org.apache.tika.mime.MediaType;

public class FormData
extends HashMap<String, AbstractParameter> {
    public FormData() {
    }

    public FormData(Map<String, AbstractParameter> formData) {
        super(formData);
    }

    public FormData add(AbstractParameter param) {
        this.put(param.name(), param);
        return this;
    }

    public FormData add(String name, String value) {
        return this.add(new StringParameter(name, value));
    }

    public FormData add(Map<String, String> parameters) {
        for (String key : parameters.keySet()) {
            this.add(new StringParameter(key, parameters.get(key)));
        }
        return this;
    }

    public FormData addFile(String name, String filename) throws IOException {
        return this.add(new StreamParameter(name, filename));
    }

    public FormData addFile(String name, File file) throws IOException {
        return this.add(new StreamParameter(name, file));
    }

    public FormData addStream(String name, File file, MediaType mimetype, InputStream stream) throws IOException {
        return this.add(new StreamParameter(name, file, mimetype, stream));
    }

    public FormData addStream(String name, String filename, MediaType mimetype, InputStream stream) throws IOException {
        return this.add(new StreamParameter(name, filename, mimetype, stream));
    }

    public void post(HttpURLConnection conn, BufferedWriter writer, String boundary) throws IOException {
        if (this.size() > 0) {
            writer.write("\n\n");
            for (String key : this.keySet()) {
                ((AbstractParameter)this.get(key)).post(conn, writer, boundary);
            }
        }
    }

    public Map<String, String> parameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : this.keySet()) {
            result.putAll(((AbstractParameter)this.get(key)).parameters());
        }
        return result;
    }
}

