/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.form;

import com.github.fracpete.requests4j.core.MimeTypeHelper;
import com.github.fracpete.requests4j.form.AbstractParameter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Map;
import org.apache.tika.mime.MediaType;

public class StreamParameter
extends AbstractParameter {
    protected String m_Filename;
    protected MediaType m_MimeType;
    protected InputStream m_Stream;

    public StreamParameter(String name, String filename) throws IOException {
        this(name, filename, MimeTypeHelper.getMimeType(filename), (InputStream)new FileInputStream(filename));
    }

    public StreamParameter(String name, File file) throws IOException {
        this(name, file.getAbsolutePath(), MimeTypeHelper.getMimeType(file), (InputStream)new FileInputStream(file));
    }

    public StreamParameter(String name, File file, MediaType mimeType, InputStream stream) {
        this(name, file.getAbsolutePath(), mimeType, stream);
    }

    public StreamParameter(String name, String filename, MediaType mimeType, InputStream stream) {
        super(name);
        this.m_Filename = filename;
        this.m_MimeType = mimeType;
        this.m_Stream = stream;
    }

    public String filename() {
        return this.m_Filename;
    }

    public MediaType mimeType() {
        return this.m_MimeType;
    }

    public InputStream stream() {
        return this.m_Stream;
    }

    @Override
    public void post(HttpURLConnection conn, BufferedWriter writer, String boundary) throws IOException {
        int read;
        writer.write("--" + boundary + "\r\n");
        writer.write("Content-Disposition: form-data; name=\"" + this.name() + "\"; filename=\"" + new File(this.filename()).getName() + "\"\r\n");
        writer.write("Content-Type: " + this.mimeType().toString() + "\r\n");
        writer.write("\r\n");
        writer.flush();
        OutputStream os = conn.getOutputStream();
        byte[] buffer = new byte[1024];
        while ((read = this.stream().read(buffer)) != -1) {
            os.write(buffer, 0, read);
        }
        os.flush();
        this.stream().close();
    }

    @Override
    public Map<String, String> parameters() {
        throw new IllegalStateException("File/Stream parameter only supports POST, not GET!");
    }

    @Override
    public String toString() {
        return this.name() + ", filename=" + this.filename() + ", mimetype=" + this.mimeType();
    }
}

