/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j;

import com.github.fracpete.requests4j.Requests;
import com.github.fracpete.requests4j.core.Request;
import com.github.fracpete.requests4j.event.RequestExecutionEvent;
import com.github.fracpete.requests4j.event.RequestExecutionListener;
import com.github.fracpete.requests4j.event.RequestFailureEvent;
import com.github.fracpete.requests4j.event.RequestFailureListener;
import com.github.fracpete.requests4j.ssl.NoHostnameVerification;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;

public class Session
implements Serializable,
RequestExecutionListener,
RequestFailureListener {
    protected Map<String, String> m_Cookies = new HashMap<String, String>();
    protected HostnameVerifier m_HostnameVerification = null;

    protected Request process(Request request) {
        request.cookies(this.m_Cookies);
        if (this.m_HostnameVerification != null) {
            request.hostnameVerification(this.m_HostnameVerification);
        }
        request.addExecutionListener(this);
        request.addFailureListener(this);
        return request;
    }

    @Override
    public void requestExecuted(RequestExecutionEvent e) {
        if (e.getReponse().ok()) {
            this.m_Cookies.putAll(e.getReponse().cookies());
        }
        e.getRequest().removeExecutionListener(this);
        e.getRequest().removeFailureListener(this);
    }

    @Override
    public void requestFailed(RequestFailureEvent e) {
        e.getRequest().removeExecutionListener(this);
        e.getRequest().removeFailureListener(this);
    }

    public Session hostnameVerification(HostnameVerifier verifier) {
        this.m_HostnameVerification = verifier;
        return this;
    }

    public Session disableHostnameVerification() {
        return this.hostnameVerification(new NoHostnameVerification());
    }

    public HostnameVerifier hostnameVerification() {
        return this.m_HostnameVerification;
    }

    public Map<String, String> cookies() {
        return this.m_Cookies;
    }

    public Request get() {
        return this.process(Requests.get());
    }

    public Request get(String url) throws MalformedURLException {
        return this.process(Requests.get(url));
    }

    public Request get(URL url) {
        return this.process(Requests.get(url));
    }

    public Request post() {
        return this.process(Requests.post());
    }

    public Request post(String url) throws MalformedURLException {
        return this.process(Requests.post(url));
    }

    public Request post(URL url) {
        return this.process(Requests.post(url));
    }

    public Request put() {
        return this.process(Requests.put());
    }

    public Request put(String url) throws MalformedURLException {
        return this.process(Requests.put(url));
    }

    public Request put(URL url) {
        return this.process(Requests.put(url));
    }

    public Request patch() {
        return this.process(Requests.patch());
    }

    public Request patch(String url) throws MalformedURLException {
        return this.process(Requests.patch(url));
    }

    public Request patch(URL url) {
        return this.process(Requests.patch(url));
    }

    public Request head() {
        return this.process(Requests.head());
    }

    public Request head(String url) throws MalformedURLException {
        return this.process(Requests.head(url));
    }

    public Request head(URL url) {
        return this.process(Requests.head(url));
    }

    public Request delete() {
        return this.process(Requests.delete());
    }

    public Request delete(String url) throws MalformedURLException {
        return this.process(Requests.delete(url));
    }

    public Request delete(URL url) {
        return this.process(Requests.delete(url));
    }

    public String toString() {
        return "cookies=" + this.cookies() + ", hostnameVerification=" + (this.hostnameVerification() == null ? "-none-" : this.hostnameVerification().toString());
    }
}

