/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.core;

import com.github.fracpete.requests4j.auth.AbstractAuthentication;
import com.github.fracpete.requests4j.auth.NoAuthentication;
import com.github.fracpete.requests4j.core.Cookies;
import com.github.fracpete.requests4j.core.HttpResponse;
import com.github.fracpete.requests4j.core.Method;
import com.github.fracpete.requests4j.core.Response;
import com.github.fracpete.requests4j.event.RequestExecutionEvent;
import com.github.fracpete.requests4j.event.RequestExecutionListener;
import com.github.fracpete.requests4j.event.RequestFailureEvent;
import com.github.fracpete.requests4j.event.RequestFailureListener;
import com.github.fracpete.requests4j.form.FormData;
import com.github.fracpete.requests4j.ssl.NoHostnameVerification;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;

public class Request
implements Serializable {
    protected Method m_Method;
    protected URL m_URL;
    protected Map<String, String> m_Headers;
    protected Cookies m_Cookies;
    protected Map<String, String> m_Parameters;
    protected Object m_Body;
    protected FormData m_FormData;
    protected AbstractAuthentication m_Authentication;
    protected int m_ConnectionTimeout;
    protected int m_ReadTimeout;
    protected boolean m_AllowRedirects;
    protected int m_MaxRedirects;
    protected Proxy m_Proxy;
    protected HostnameVerifier m_HostnameVerification;
    protected transient Set<RequestExecutionListener> m_ExecutionListeners;
    protected transient Set<RequestFailureListener> m_FailureListeners;

    public Request(Method method) {
        this.m_Method = method;
        this.m_URL = null;
        this.m_Headers = new HashMap<String, String>();
        this.m_Cookies = new Cookies();
        this.m_Parameters = new HashMap<String, String>();
        this.m_Authentication = new NoAuthentication();
        this.m_Body = null;
        this.m_FormData = new FormData();
        this.m_ConnectionTimeout = -1;
        this.m_ReadTimeout = -1;
        this.m_AllowRedirects = false;
        this.m_MaxRedirects = 3;
        this.m_Proxy = null;
        this.m_HostnameVerification = null;
    }

    public Method method() {
        return this.m_Method;
    }

    public Request url(String url) throws MalformedURLException {
        this.m_URL = new URL(url);
        return this;
    }

    public Request url(URL url) {
        this.m_URL = url;
        return this;
    }

    public URL url() {
        return this.m_URL;
    }

    public Request header(String name, String value) {
        this.m_Headers.put(name, value);
        return this;
    }

    public Request headers(Map<String, String> headers) {
        this.m_Headers.putAll(headers);
        return this;
    }

    public Map<String, String> headers() {
        return this.m_Headers;
    }

    public Request cookie(String name, String value) {
        this.m_Cookies.put(name, value);
        return this;
    }

    public Request cookies(Map<String, String> cookies) {
        this.m_Cookies.putAll(cookies);
        return this;
    }

    public Request cookies(Cookies cookies) {
        this.m_Cookies.putAll(cookies);
        return this;
    }

    public Cookies cookies() {
        return this.m_Cookies;
    }

    public Request parameter(String name, String value) {
        this.m_Parameters.put(name, value);
        return this;
    }

    public Request parameters(Map<String, String> parameters) {
        this.m_Parameters.putAll(parameters);
        return this;
    }

    public Map<String, String> parameters() {
        return this.m_Parameters;
    }

    public Request body(String body) {
        if (this.m_Method.hasBody()) {
            this.m_Body = body;
        } else {
            System.err.println("Method " + (Object)((Object)this.m_Method) + " does not support a body!");
        }
        return this;
    }

    public Request body(byte[] body) {
        if (this.m_Method.hasBody()) {
            this.m_Body = body;
        } else {
            System.err.println("Method " + (Object)((Object)this.m_Method) + " does not support a body!");
        }
        return this;
    }

    public Object body() {
        return this.m_Body;
    }

    public Request formData(FormData formData) {
        this.m_FormData.putAll(formData);
        return this;
    }

    public FormData formData() {
        return this.m_FormData;
    }

    public Request auth(AbstractAuthentication auth) {
        if (auth == null) {
            auth = new NoAuthentication();
        }
        this.m_Authentication = auth;
        return this;
    }

    public AbstractAuthentication auth() {
        return this.m_Authentication;
    }

    public Request timeouts(int connection, int read) {
        this.connectionTimeout(connection);
        this.readTimeout(read);
        return this;
    }

    public Request connectionTimeout(int timeout) {
        this.m_ConnectionTimeout = timeout;
        return this;
    }

    public int connectionTimeout() {
        return this.m_ConnectionTimeout;
    }

    public Request readTimeout(int timeout) {
        this.m_ReadTimeout = timeout;
        return this;
    }

    public int readTimeout() {
        return this.m_ReadTimeout;
    }

    public Request allowRedirects(boolean allow) {
        this.m_AllowRedirects = allow;
        return this;
    }

    public boolean allowRedirects() {
        return this.m_AllowRedirects;
    }

    public Request maxRedirects(int max) {
        if (max < 0) {
            max = 0;
        }
        this.m_MaxRedirects = max;
        return this;
    }

    public int maxRedirects() {
        return this.m_MaxRedirects;
    }

    public Request proxy(Proxy.Type type, String server, int port) {
        this.m_Proxy = new Proxy(type, new InetSocketAddress(server, port));
        return this;
    }

    public Request noProxy() {
        this.m_Proxy = null;
        return this;
    }

    public Proxy proxy() {
        return this.m_Proxy;
    }

    public Request hostnameVerification(HostnameVerifier verifier) {
        this.m_HostnameVerification = verifier;
        return this;
    }

    public Request disableHostnameVerification() {
        return this.hostnameVerification(new NoHostnameVerification());
    }

    public HostnameVerifier hostnameVerification() {
        return this.m_HostnameVerification;
    }

    public synchronized Request addExecutionListener(RequestExecutionListener l) {
        if (this.m_ExecutionListeners == null) {
            this.m_ExecutionListeners = new HashSet<RequestExecutionListener>();
        }
        this.m_ExecutionListeners.add(l);
        return this;
    }

    public synchronized Request removeExecutionListener(RequestExecutionListener l) {
        if (this.m_ExecutionListeners != null) {
            this.m_ExecutionListeners.remove(l);
        }
        return this;
    }

    protected synchronized void notifyExecutionListeners(RequestExecutionEvent e) {
        if (this.m_ExecutionListeners == null) {
            return;
        }
        for (RequestExecutionListener l : this.m_ExecutionListeners) {
            l.requestExecuted(e);
        }
    }

    public synchronized Request addFailureListener(RequestFailureListener l) {
        if (this.m_FailureListeners == null) {
            this.m_FailureListeners = new HashSet<RequestFailureListener>();
        }
        this.m_FailureListeners.add(l);
        return this;
    }

    public synchronized Request removeFailureListener(RequestFailureListener l) {
        if (this.m_FailureListeners != null) {
            this.m_FailureListeners.remove(l);
        }
        return this;
    }

    protected synchronized void notifyFailureListeners(RequestFailureEvent e) {
        if (this.m_FailureListeners == null) {
            return;
        }
        for (RequestFailureListener l : this.m_FailureListeners) {
            l.requestFailed(e);
        }
    }

    protected URL assembleURL() throws Exception {
        URL result;
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.m_Method != Method.POST) {
            params.putAll(this.m_Parameters);
            params.putAll(this.formData().parameters());
        }
        if (params.size() > 0) {
            String enc = "UTF-8";
            StringBuilder url = new StringBuilder(this.m_URL.toString());
            int i = 0;
            for (String key : params.keySet()) {
                if (i == 0) {
                    url.append("?");
                } else {
                    url.append("&");
                }
                url.append(URLEncoder.encode(key, enc));
                url.append("=");
                url.append(URLEncoder.encode((String)params.get(key), enc));
                ++i;
            }
            result = new URL(url.toString());
        } else {
            result = this.m_URL;
        }
        return result;
    }

    protected String createBoundary() {
        Random rand = new Random();
        String result = Integer.toHexString(rand.nextInt()) + Integer.toHexString(rand.nextInt()) + Integer.toHexString(rand.nextInt());
        return result;
    }

    protected HttpURLConnection openConnection(URL url) throws IOException {
        BufferedWriter writer;
        HttpURLConnection result = this.m_Proxy != null ? (HttpURLConnection)url.openConnection(this.m_Proxy) : (HttpURLConnection)url.openConnection();
        if (result instanceof HttpsURLConnection && this.m_HostnameVerification != null) {
            ((HttpsURLConnection)result).setHostnameVerifier(this.m_HostnameVerification);
        }
        if (this.m_ConnectionTimeout >= 0) {
            result.setConnectTimeout(this.m_ConnectionTimeout);
        }
        if (this.m_ReadTimeout >= 0) {
            result.setReadTimeout(this.m_ReadTimeout);
        }
        result.setDoInput(true);
        result.setDoOutput(true);
        result.setRequestMethod(this.m_Method.toString());
        for (String key : this.m_Headers.keySet()) {
            result.setRequestProperty(key, this.m_Headers.get(key));
        }
        for (String key : this.m_Cookies.keySet()) {
            result.setRequestProperty("Cookie", key + "=" + (String)this.m_Cookies.get(key));
        }
        boolean writeBody = false;
        if (this.m_Method.hasBody()) {
            if (this.m_Method == Method.POST) {
                if (this.m_FormData.size() > 0) {
                    String boundary = this.createBoundary();
                    result.addRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundary);
                    writer = new BufferedWriter(new OutputStreamWriter(result.getOutputStream()));
                    this.m_FormData.post(result, writer, boundary);
                    writer.close();
                } else if (this.body() != null) {
                    writeBody = true;
                }
            } else {
                boolean bl = writeBody = this.body() != null;
            }
        }
        if (writeBody) {
            if (this.body() instanceof String) {
                writer = new BufferedWriter(new OutputStreamWriter(result.getOutputStream()));
                writer.write((String)this.body());
                writer.close();
            } else if (this.body() instanceof byte[]) {
                result.getOutputStream().write((byte[])this.body());
            } else {
                throw new IllegalStateException("Unhandled body type (expected String or byte[]), found: " + this.body().getClass());
            }
        }
        return result;
    }

    protected HttpURLConnection getConnection(URL url) throws IOException {
        HttpURLConnection result = this.openConnection(url);
        int status = result.getResponseCode();
        int redirectCount = 0;
        while (status == 302 || status == 301 || status == 303) {
            if (!this.m_AllowRedirects) {
                throw new IOException("Received a redirect and no redirects allowed!");
            }
            if (++redirectCount >= this.m_MaxRedirects) {
                throw new IOException(this.m_MaxRedirects + " redirects were generated when trying to access " + url);
            }
            String newURL = result.getHeaderField("Location");
            System.out.println("Redirect, trying to open: " + newURL);
            result = this.openConnection(new URL(newURL));
            status = result.getResponseCode();
        }
        return result;
    }

    public Response execute() throws Exception {
        return this.execute(new Response());
    }

    public <T extends HttpResponse> T execute(T response) throws Exception {
        try {
            int b;
            if (this.m_URL == null) {
                throw new IllegalStateException("No URL provided!");
            }
            this.m_Authentication.apply(this);
            URL url = this.assembleURL();
            HttpURLConnection conn = this.getConnection(url);
            response.init(conn.getResponseCode(), conn.getResponseMessage(), conn.getHeaderFields());
            InputStream in = conn.getInputStream();
            while ((b = in.read()) != -1) {
                response.appendBody((byte)b);
            }
            response.finishBody();
            conn.disconnect();
            this.notifyExecutionListeners(new RequestExecutionEvent(this, response));
        }
        catch (Throwable t) {
            this.notifyFailureListeners(new RequestFailureEvent(this, t));
            throw t;
        }
        return response;
    }
}

