/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.core;

import com.github.fracpete.requests4j.core.AbstractResponse;
import gnu.trove.list.TByteList;
import gnu.trove.list.array.TByteArrayList;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.List;
import java.util.Map;

public class Response
extends AbstractResponse {
    protected TByteList m_Body;

    @Override
    public void init(int statusCode, String statusMessage, Map<String, List<String>> headers) {
        super.init(statusCode, statusMessage, headers);
        this.m_Body = new TByteArrayList();
    }

    @Override
    public void appendBody(byte b) throws IOException {
        this.m_Body.add(b);
    }

    @Override
    public void finishBody() throws IOException {
    }

    public byte[] body() {
        return this.m_Body.toArray();
    }

    public String text() throws UnsupportedEncodingException {
        return this.text("UTF-8");
    }

    public String text(String encoding) throws UnsupportedEncodingException {
        return new String(this.body(), encoding);
    }

    public void saveBody(String filename) throws IOException {
        this.saveBody(new File(filename));
    }

    public void saveBody(File file) throws IOException {
        Files.write(file.toPath(), this.body(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public String toString() {
        return super.toString() + ", body length: " + this.body().length;
    }
}

