/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;

public class MimeTypeHelper {
    public static MediaType getMimeType(File file) {
        return MimeTypeHelper.getMimeType(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MediaType getMimeType(String filename) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(filename);
            bis = new BufferedInputStream(fis);
            AutoDetectParser parser = new AutoDetectParser();
            Detector detector = parser.getDetector();
            Metadata md = new Metadata();
            md.add("resourceName", filename);
            MediaType result = detector.detect((InputStream)bis, md);
            bis.close();
            MediaType mediaType = result;
            return mediaType;
        }
        catch (Exception e) {
            MediaType mediaType = MediaType.OCTET_STREAM;
            return mediaType;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

