/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.request;

import com.github.fracpete.requests4j.auth.AbstractAuthentication;
import com.github.fracpete.requests4j.auth.NoAuthentication;
import com.github.fracpete.requests4j.event.RequestExecutionEvent;
import com.github.fracpete.requests4j.event.RequestExecutionListener;
import com.github.fracpete.requests4j.event.RequestFailureEvent;
import com.github.fracpete.requests4j.event.RequestFailureListener;
import com.github.fracpete.requests4j.form.FormData;
import com.github.fracpete.requests4j.request.Method;
import com.github.fracpete.requests4j.response.BasicResponse;
import com.github.fracpete.requests4j.response.Response;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpOptions;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.cookie.Cookie;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.protocol.HttpContext;

public class Request
implements Serializable {
    protected Method m_Method;
    protected URL m_URL;
    protected CloseableHttpClient m_Client;
    protected boolean m_CloseClient;
    protected CookieStore m_Cookies;
    protected CredentialsProvider m_Credentials;
    protected AbstractAuthentication m_Authentication;
    protected HttpHost m_Proxy;
    protected Map<String, String> m_Headers;
    protected Map<String, String> m_Parameters;
    protected Object m_Body;
    protected FormData m_FormData;
    protected ContentType m_BodyContentType;
    protected int m_SocketTimeout;
    protected int m_ConnectTimeout;
    protected int m_ConnectionRequestTimeout;
    protected boolean m_AllowRedirects;
    protected int m_MaxRedirects;
    protected transient Set<RequestExecutionListener> m_ExecutionListeners;
    protected transient Set<RequestFailureListener> m_FailureListeners;
    protected int m_RedirectCount;

    public Request(Method method) {
        this.m_Method = method;
        this.m_URL = null;
        this.m_Client = null;
        this.m_CloseClient = true;
        this.m_Cookies = null;
        this.m_Credentials = null;
        this.m_Authentication = new NoAuthentication();
        this.m_Proxy = null;
        this.m_Headers = new HashMap<String, String>();
        this.m_Parameters = new HashMap<String, String>();
        this.m_Body = null;
        this.m_BodyContentType = ContentType.APPLICATION_OCTET_STREAM;
        this.m_FormData = new FormData();
        this.m_SocketTimeout = -1;
        this.m_ConnectTimeout = -1;
        this.m_ConnectionRequestTimeout = -1;
        this.m_AllowRedirects = false;
        this.m_MaxRedirects = 3;
        this.m_RedirectCount = 0;
    }

    public Method method() {
        return this.m_Method;
    }

    public Request url(String url) throws MalformedURLException {
        this.m_URL = new URL(url);
        return this;
    }

    public Request url(URL url) {
        this.m_URL = url;
        return this;
    }

    public URL url() {
        return this.m_URL;
    }

    public Request client(CloseableHttpClient value) {
        this.m_Client = value;
        this.m_CloseClient = false;
        return this;
    }

    public CloseableHttpClient client() {
        if (this.m_Client == null) {
            this.m_Client = HttpClients.custom().setDefaultCookieStore(this.cookies()).setDefaultCredentialsProvider(this.credentials()).disableRedirectHandling().build();
        }
        return this.m_Client;
    }

    public Request cookies(CookieStore value) {
        this.m_Cookies = value;
        return this;
    }

    public Request cookies(Map<String, String> value) {
        for (String key : value.keySet()) {
            this.cookies().addCookie((Cookie)new BasicClientCookie(key, value.get(key)));
        }
        return this;
    }

    public CookieStore cookies() {
        if (this.m_Cookies == null) {
            this.m_Cookies = new BasicCookieStore();
        }
        return this.m_Cookies;
    }

    public Request cookie(String name, String value) {
        return this.cookie(null, null, name, value);
    }

    public Request cookie(String domain, String path, String name, String value) {
        BasicClientCookie cookie = new BasicClientCookie(name, value);
        if (domain != null) {
            cookie.setDomain(domain);
        }
        if (path != null) {
            cookie.setPath(path);
        }
        this.m_Cookies.addCookie((Cookie)cookie);
        return this;
    }

    public Request credentials(CredentialsProvider value) {
        this.m_Credentials = value;
        return this;
    }

    public CredentialsProvider credentials() {
        if (this.m_Credentials == null) {
            this.m_Credentials = new BasicCredentialsProvider();
        }
        return this.m_Credentials;
    }

    public Request header(String name, String value) {
        this.m_Headers.put(name, value);
        return this;
    }

    public Request headers(Map<String, String> headers) {
        this.m_Headers.putAll(headers);
        return this;
    }

    public Map<String, String> headers() {
        return this.m_Headers;
    }

    public Request parameter(String name, String value) {
        this.m_Parameters.put(name, value);
        return this;
    }

    public Request parameters(Map<String, String> parameters) {
        this.m_Parameters.putAll(parameters);
        return this;
    }

    public Map<String, String> parameters() {
        return this.m_Parameters;
    }

    public Request auth(AbstractAuthentication auth) {
        if (auth == null) {
            auth = new NoAuthentication();
        }
        this.m_Authentication = auth;
        return this;
    }

    public AbstractAuthentication auth() {
        return this.m_Authentication;
    }

    public Request proxy(String host, int port, String scheme) {
        this.m_Proxy = new HttpHost(host, port, scheme);
        return this;
    }

    public Request proxy(HttpHost value) {
        this.m_Proxy = value;
        return this;
    }

    public Request noProxy() {
        this.m_Proxy = null;
        return this;
    }

    public HttpHost proxy() {
        return this.m_Proxy;
    }

    public Request body(String value) {
        return this.body(value, ContentType.TEXT_PLAIN);
    }

    public Request body(String value, ContentType contentType) {
        if (!this.m_Method.hasBody()) {
            throw new IllegalArgumentException("Method " + (Object)((Object)this.m_Method) + " does not support a body!");
        }
        this.m_Body = value;
        this.m_BodyContentType = contentType;
        return this;
    }

    public Request body(byte[] value) {
        return this.body(value, ContentType.APPLICATION_OCTET_STREAM);
    }

    public Request body(byte[] value, ContentType contentType) {
        if (!this.m_Method.hasBody()) {
            throw new IllegalArgumentException("Method " + (Object)((Object)this.m_Method) + " does not support a body!");
        }
        this.m_Body = value;
        this.m_BodyContentType = contentType;
        return this;
    }

    public Object body() {
        return this.m_Body;
    }

    public Request formData(FormData formData) {
        this.m_FormData.putAll(formData);
        return this;
    }

    public FormData formData() {
        return this.m_FormData;
    }

    public Request socketTimeout(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_SocketTimeout = value;
        return this;
    }

    public int socketTimeout() {
        return this.m_SocketTimeout;
    }

    public Request connectTimeout(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ConnectTimeout = value;
        return this;
    }

    public int connectTimeout() {
        return this.m_ConnectTimeout;
    }

    public Request connectionRequestTimeout(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ConnectionRequestTimeout = value;
        return this;
    }

    public int connectionRequestTimeout() {
        return this.m_ConnectionRequestTimeout;
    }

    public Request allowRedirects(boolean allow) {
        this.m_AllowRedirects = allow;
        return this;
    }

    public boolean allowRedirects() {
        return this.m_AllowRedirects;
    }

    public Request maxRedirects(int max) {
        if (max < 0) {
            max = 0;
        }
        this.m_MaxRedirects = max;
        return this;
    }

    public int maxRedirects() {
        return this.m_MaxRedirects;
    }

    public synchronized Request addExecutionListener(RequestExecutionListener l) {
        if (this.m_ExecutionListeners == null) {
            this.m_ExecutionListeners = new HashSet<RequestExecutionListener>();
        }
        this.m_ExecutionListeners.add(l);
        return this;
    }

    public synchronized Request removeExecutionListener(RequestExecutionListener l) {
        if (this.m_ExecutionListeners != null) {
            this.m_ExecutionListeners.remove(l);
        }
        return this;
    }

    protected synchronized void notifyExecutionListeners(RequestExecutionEvent e) {
        if (this.m_ExecutionListeners == null) {
            return;
        }
        for (RequestExecutionListener l : this.m_ExecutionListeners) {
            l.requestExecuted(e);
        }
    }

    public synchronized Request addFailureListener(RequestFailureListener l) {
        if (this.m_FailureListeners == null) {
            this.m_FailureListeners = new HashSet<RequestFailureListener>();
        }
        this.m_FailureListeners.add(l);
        return this;
    }

    public synchronized Request removeFailureListener(RequestFailureListener l) {
        if (this.m_FailureListeners != null) {
            this.m_FailureListeners.remove(l);
        }
        return this;
    }

    protected synchronized void notifyFailureListeners(RequestFailureEvent e) {
        if (this.m_FailureListeners == null) {
            return;
        }
        for (RequestFailureListener l : this.m_FailureListeners) {
            l.requestFailed(e);
        }
    }

    protected boolean isRedirect(int statusCode) {
        return statusCode == 302 || statusCode == 301 || statusCode == 303;
    }

    protected boolean canCloseClient(Response response) {
        boolean result = this.m_CloseClient;
        if (this.m_AllowRedirects && response != null && this.isRedirect(response.statusCode())) {
            result = this.m_RedirectCount >= this.m_MaxRedirects;
        }
        return result;
    }

    protected URL assembleURL() throws Exception {
        URL result;
        HashMap<String, String> params = new HashMap<String, String>();
        if (this.m_Method != Method.POST) {
            params.putAll(this.m_Parameters);
            params.putAll(this.formData().parameters());
        }
        if (params.size() > 0) {
            String enc = "UTF-8";
            StringBuilder url = new StringBuilder(this.m_URL.toString());
            int i = 0;
            for (String key : params.keySet()) {
                if (i == 0) {
                    url.append("?");
                } else {
                    url.append("&");
                }
                url.append(URLEncoder.encode(key, enc));
                url.append("=");
                url.append(URLEncoder.encode((String)params.get(key), enc));
                ++i;
            }
            result = new URL(url.toString());
        } else {
            result = this.m_URL;
        }
        return result;
    }

    public BasicResponse execute() throws Exception {
        return this.execute(new BasicResponse());
    }

    protected <T extends Response> T doExecute(T response) throws Exception {
        Iterator<String> iterator;
        URL url = this.assembleURL();
        try {
            HttpGet request;
            switch (this.m_Method) {
                case GET: {
                    request = new HttpGet(url.toURI());
                    break;
                }
                case POST: {
                    request = new HttpPost(url.toURI());
                    break;
                }
                case DELETE: {
                    request = new HttpDelete(url.toURI());
                    break;
                }
                case PUT: {
                    request = new HttpPut(url.toURI());
                    break;
                }
                case HEAD: {
                    request = new HttpHead(url.toURI());
                    break;
                }
                case PATCH: {
                    request = new HttpPatch(url.toURI());
                    break;
                }
                case OPTIONS: {
                    request = new HttpOptions(url.toURI());
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported method: " + (Object)((Object)this.m_Method));
                }
            }
            RequestConfig.Builder configBuilder = null;
            if (this.m_SocketTimeout != -1 || this.m_ConnectTimeout != -1 || this.m_ConnectionRequestTimeout != -1) {
                if (configBuilder == null) {
                    configBuilder = RequestConfig.custom();
                }
                if (this.m_SocketTimeout != -1) {
                    configBuilder.setSocketTimeout(this.m_SocketTimeout);
                }
                if (this.m_ConnectTimeout != -1) {
                    configBuilder.setConnectTimeout(this.m_ConnectTimeout);
                }
                if (this.m_ConnectionRequestTimeout != -1) {
                    configBuilder.setConnectionRequestTimeout(this.m_ConnectionRequestTimeout);
                }
            }
            if (this.m_Proxy != null) {
                if (configBuilder == null) {
                    configBuilder = RequestConfig.custom();
                }
                configBuilder.setProxy(this.m_Proxy);
            }
            if (configBuilder != null) {
                request.setConfig(configBuilder.build());
            }
            for (String header : this.headers().keySet()) {
                request.addHeader(header, this.headers().get(header));
            }
            if (request instanceof HttpPost && this.m_FormData.size() > 0) {
                this.m_FormData.add((HttpPost)request);
            } else if (this.m_Body != null && request instanceof HttpEntityEnclosingRequest) {
                if (this.m_Body instanceof String) {
                    ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new StringEntity((String)this.m_Body, this.m_BodyContentType));
                } else if (this.m_Body instanceof byte[]) {
                    ((HttpEntityEnclosingRequest)request).setEntity((HttpEntity)new ByteArrayEntity((byte[])this.m_Body, this.m_BodyContentType));
                } else {
                    throw new IllegalStateException("Unhandled body type: " + this.m_Body.getClass().getName());
                }
            }
            HttpClientContext context = this.m_Authentication.build(this);
            CloseableHttpResponse resp = context == null ? this.client().execute((HttpUriRequest)request) : this.client().execute((HttpUriRequest)request, (HttpContext)context);
            response.init(resp);
            try {
                resp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifyExecutionListeners(new RequestExecutionEvent(this, response));
            iterator = response;
        }
        catch (Throwable t) {
            this.notifyFailureListeners(new RequestFailureEvent(this, t));
            throw t;
        }
        finally {
            this.m_FormData.cleanUp();
            if (this.canCloseClient(response)) {
                try {
                    this.m_Client.close();
                }
                catch (Exception exception) {}
            }
        }
        return (T)iterator;
    }

    public <T extends Response> T execute(T response) throws Exception {
        response = this.doExecute(response);
        int status = response.statusCode();
        this.m_RedirectCount = 0;
        while (this.isRedirect(status)) {
            if (!this.m_AllowRedirects) {
                throw new IOException("Received a redirect and no redirects allowed!");
            }
            ++this.m_RedirectCount;
            if (this.m_RedirectCount >= this.m_MaxRedirects) {
                throw new IOException(this.m_MaxRedirects + " redirects were generated when trying to access " + this.m_URL);
            }
            String newURL = response.rawResponse().getFirstHeader("Location").getValue();
            System.out.println("Redirect, trying to open: " + newURL);
            this.url(newURL);
            response = this.doExecute(response);
            status = response.statusCode();
        }
        return response;
    }
}

