/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.response;

import com.github.fracpete.requests4j.response.AbstractResponse;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.tika.io.IOUtils;

public class FileResponse
extends AbstractResponse {
    protected File m_OutputFile;
    protected int m_BufferSize;

    public FileResponse(String outputFilename) {
        this(new File(outputFilename));
    }

    public FileResponse(String outputFilename, int bufferSize) {
        this(new File(outputFilename), bufferSize);
    }

    public FileResponse(File outputFile) {
        this(outputFile, -1);
    }

    public FileResponse(File outputFile, int bufferSize) {
        if (bufferSize <= 0) {
            bufferSize = -1;
        }
        this.m_OutputFile = outputFile;
        this.m_BufferSize = bufferSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void init(CloseableHttpResponse response) {
        super.init(response);
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            fos = new FileOutputStream(this.m_OutputFile.getAbsolutePath());
            bos = this.m_BufferSize <= 0 ? new BufferedOutputStream(fos) : new BufferedOutputStream(fos, this.m_BufferSize);
            IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)bos);
        }
        catch (Exception exception) {
            IOUtils.closeQuietly(bos);
            IOUtils.closeQuietly((OutputStream)fos);
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((OutputStream)fos);
    }

    public File outputFile() {
        return this.m_OutputFile;
    }

    public int bufferSize() {
        return this.m_BufferSize;
    }

    @Override
    public String toString() {
        return super.toString() + ", outputFile=" + this.outputFile() + ", bufferSize=" + (this.bufferSize() <= 0 ? "-default-" : "" + this.bufferSize());
    }
}

