/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.response;

import com.github.fracpete.requests4j.response.AbstractResponse;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.tika.io.IOUtils;

public class StreamResponse
extends AbstractResponse {
    protected OutputStream m_OutputStream;
    protected boolean m_CloseOnFinish;

    public StreamResponse(OutputStream outputStream) {
        this(outputStream, false);
    }

    public StreamResponse(OutputStream outputStream, boolean closeOnFinish) {
        this.m_OutputStream = outputStream;
        this.m_CloseOnFinish = closeOnFinish;
    }

    public OutputStream outputStream() {
        return this.m_OutputStream;
    }

    public boolean closeOnFinish() {
        return this.m_CloseOnFinish;
    }

    @Override
    public void init(CloseableHttpResponse response) {
        super.init(response);
        try {
            IOUtils.copy((InputStream)response.getEntity().getContent(), (OutputStream)this.m_OutputStream);
        }
        catch (Exception exception) {
        }
        finally {
            if (this.m_CloseOnFinish) {
                IOUtils.closeQuietly((OutputStream)this.m_OutputStream);
            }
        }
    }

    @Override
    public String toString() {
        return super.toString() + ", closeOnFinish=" + this.closeOnFinish();
    }
}

