/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j;

import com.github.fracpete.requests4j.Requests;
import com.github.fracpete.requests4j.event.RequestExecutionEvent;
import com.github.fracpete.requests4j.event.RequestExecutionListener;
import com.github.fracpete.requests4j.event.RequestFailureEvent;
import com.github.fracpete.requests4j.event.RequestFailureListener;
import com.github.fracpete.requests4j.request.Request;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class Session
implements Serializable,
RequestExecutionListener,
RequestFailureListener {
    protected CloseableHttpClient m_Client;
    protected CookieStore m_Cookies;
    protected CredentialsProvider m_Credentials;

    protected Request process(Request request) {
        request.client(this.client());
        request.cookies(this.cookies());
        request.credentials(this.credentials());
        return request;
    }

    @Override
    public void requestExecuted(RequestExecutionEvent e) {
        e.getRequest().removeExecutionListener(this);
        e.getRequest().removeFailureListener(this);
    }

    @Override
    public void requestFailed(RequestFailureEvent e) {
        e.getRequest().removeExecutionListener(this);
        e.getRequest().removeFailureListener(this);
    }

    public synchronized CloseableHttpClient client() {
        if (this.m_Client == null) {
            this.m_Client = HttpClients.custom().setDefaultCookieStore(this.cookies()).setDefaultCredentialsProvider(this.credentials()).build();
        }
        return this.m_Client;
    }

    public CookieStore cookies() {
        if (this.m_Cookies == null) {
            this.m_Cookies = new BasicCookieStore();
        }
        return this.m_Cookies;
    }

    public CredentialsProvider credentials() {
        if (this.m_Credentials == null) {
            this.m_Credentials = new BasicCredentialsProvider();
        }
        return this.m_Credentials;
    }

    public Request get() {
        return this.process(Requests.get());
    }

    public Request get(String url) throws MalformedURLException {
        return this.process(Requests.get(url));
    }

    public Request get(URL url) {
        return this.process(Requests.get(url));
    }

    public Request post() {
        return this.process(Requests.post());
    }

    public Request post(String url) throws MalformedURLException {
        return this.process(Requests.post(url));
    }

    public Request post(URL url) {
        return this.process(Requests.post(url));
    }

    public Request put() {
        return this.process(Requests.put());
    }

    public Request put(String url) throws MalformedURLException {
        return this.process(Requests.put(url));
    }

    public Request put(URL url) {
        return this.process(Requests.put(url));
    }

    public Request patch() {
        return this.process(Requests.patch());
    }

    public Request patch(String url) throws MalformedURLException {
        return this.process(Requests.patch(url));
    }

    public Request patch(URL url) {
        return this.process(Requests.patch(url));
    }

    public Request head() {
        return this.process(Requests.head());
    }

    public Request head(String url) throws MalformedURLException {
        return this.process(Requests.head(url));
    }

    public Request head(URL url) {
        return this.process(Requests.head(url));
    }

    public Request options() {
        return this.process(Requests.options());
    }

    public Request options(String url) throws MalformedURLException {
        return this.process(Requests.options(url));
    }

    public Request options(URL url) {
        return this.process(Requests.options(url));
    }

    public Request delete() {
        return this.process(Requests.delete());
    }

    public Request delete(String url) throws MalformedURLException {
        return this.process(Requests.delete(url));
    }

    public Request delete(URL url) {
        return this.process(Requests.delete(url));
    }

    public void close() {
        if (this.m_Client != null) {
            try {
                this.m_Client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return "cookies=" + this.cookies();
    }
}

