/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.attachment;

import com.github.fracpete.requests4j.attachment.AbstractAttachment;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;

public class ByteArrayAttachment
extends AbstractAttachment {
    protected byte[] m_Content;
    protected ContentType m_ContentType;

    public ByteArrayAttachment(byte[] content) {
        this(content, ContentType.APPLICATION_OCTET_STREAM);
    }

    public ByteArrayAttachment(byte[] content, ContentType contentType) {
        this.m_Content = content;
        this.m_ContentType = contentType;
    }

    @Override
    public boolean canResend() {
        return true;
    }

    public byte[] content() {
        return this.m_Content;
    }

    public ContentType contentType() {
        return this.m_ContentType;
    }

    @Override
    public boolean isValid() {
        return this.m_Content != null && this.m_ContentType != null;
    }

    @Override
    public String getContentDisposition() {
        return "attachment";
    }

    @Override
    public HttpEntity getEntity() {
        return new InputStreamEntity((InputStream)new ByteArrayInputStream(this.m_Content), (long)this.m_Content.length);
    }

    @Override
    public String toString() {
        return "#bytes=" + (this.content() != null ? this.content().length : 0) + ", contentType=" + this.contentType();
    }
}

