/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.attachment;

import com.github.fracpete.requests4j.attachment.AbstractAttachment;
import java.io.File;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;

public class FileAttachment
extends AbstractAttachment {
    protected File m_File;
    protected String m_Name;
    protected ContentType m_ContentType;

    public FileAttachment(File file) {
        this(file, ContentType.APPLICATION_OCTET_STREAM);
    }

    public FileAttachment(File file, ContentType contentType) {
        this(file, file.getName(), contentType);
    }

    public FileAttachment(File file, String name, ContentType contentType) {
        this.m_File = file;
        this.m_Name = name;
        this.m_ContentType = contentType;
    }

    @Override
    public boolean canResend() {
        return true;
    }

    public File file() {
        return this.m_File;
    }

    public String name() {
        return this.m_Name;
    }

    public ContentType contentType() {
        return this.m_ContentType;
    }

    @Override
    public boolean isValid() {
        return this.m_File != null && this.m_File.exists() && !this.m_File.isDirectory() && this.m_Name != null && this.m_ContentType != null;
    }

    @Override
    public String getContentDisposition() {
        return "attachment; filename=" + this.m_Name;
    }

    @Override
    public HttpEntity getEntity() {
        return new FileEntity(this.m_File, this.m_ContentType);
    }

    @Override
    public String toString() {
        return "file=" + this.file() + ", name=" + this.name() + ", contentType=" + this.contentType();
    }
}

