/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.form;

import com.github.fracpete.requests4j.form.AbstractParameter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.tika.mime.MediaType;

public class ByteArrayParameter
extends AbstractParameter {
    protected String m_Filename;
    protected MediaType m_MimeType;
    protected byte[] m_Data;

    public ByteArrayParameter(String name, MediaType mimeType, byte[] data) {
        super(name);
        if (data == null) {
            throw new IllegalArgumentException("Byte array cannot be null!");
        }
        this.m_MimeType = mimeType;
        this.m_Data = data;
    }

    @Override
    public boolean canResend() {
        return false;
    }

    public MediaType mimeType() {
        return this.m_MimeType;
    }

    public byte[] data() {
        return this.m_Data;
    }

    @Override
    public void add(MultipartEntityBuilder multipart) throws IOException {
        InputStreamBody streambody = new InputStreamBody((InputStream)new ByteArrayInputStream(this.m_Data), ContentType.create((String)this.mimeType().toString()));
        multipart.addPart(this.name(), (ContentBody)streambody);
    }

    @Override
    public Map<String, String> parameters() {
        throw new IllegalStateException("Byte array parameter only supports POST, not GET!");
    }

    @Override
    public String toString() {
        return this.name() + ", #bytes=" + this.data().length + ", mimetype=" + this.mimeType();
    }
}

