/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.form;

import com.github.fracpete.requests4j.core.MimeTypeHelper;
import com.github.fracpete.requests4j.form.AbstractParameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.tika.mime.MediaType;

public class StreamParameter
extends AbstractParameter {
    protected String m_Filename;
    protected MediaType m_MimeType;
    protected InputStream m_Stream;

    public StreamParameter(String name, String filename) {
        this(name, filename, MimeTypeHelper.getMimeType(filename), null);
    }

    public StreamParameter(String name, File file) {
        this(name, file.getAbsolutePath(), MimeTypeHelper.getMimeType(file), null);
    }

    public StreamParameter(String name, File file, MediaType mimeType, InputStream stream) {
        this(name, file.getAbsolutePath(), mimeType, stream);
    }

    public StreamParameter(String name, String filename, MediaType mimeType, InputStream stream) {
        super(name);
        this.m_Filename = filename;
        this.m_MimeType = mimeType;
        this.m_Stream = stream;
    }

    @Override
    public boolean canResend() {
        return this.m_Stream == null;
    }

    public String filename() {
        return this.m_Filename;
    }

    public MediaType mimeType() {
        return this.m_MimeType;
    }

    public InputStream stream() {
        return this.m_Stream;
    }

    @Override
    public void add(MultipartEntityBuilder multipart) throws IOException {
        if (this.m_Stream != null) {
            InputStreamBody streambody = new InputStreamBody(this.m_Stream, ContentType.create((String)this.mimeType().toString()), new File(this.filename()).getName());
            multipart.addPart(this.name(), (ContentBody)streambody);
        } else {
            FileBody filebody = new FileBody(new File(this.m_Filename), ContentType.create((String)this.mimeType().toString()));
            multipart.addPart(this.name(), (ContentBody)filebody);
        }
    }

    @Override
    public Map<String, String> parameters() {
        throw new IllegalStateException("File/Stream parameter only supports POST, not GET!");
    }

    @Override
    public String toString() {
        return this.name() + ", filename=" + this.filename() + ", mimetype=" + this.mimeType();
    }
}

