/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.form;

import com.github.fracpete.requests4j.form.AbstractParameter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

public class StringParameter
extends AbstractParameter {
    protected String m_Value;

    public StringParameter(String name, String value) {
        super(name);
        if (value == null) {
            throw new IllegalStateException("String parameter value cannot be null (name=" + name + ")!");
        }
        this.m_Value = value;
    }

    @Override
    public boolean canResend() {
        return true;
    }

    public String value() {
        return this.m_Value;
    }

    @Override
    public void add(MultipartEntityBuilder multipart) throws IOException {
        multipart.addPart(this.name(), (ContentBody)new StringBody(this.value(), ContentType.MULTIPART_FORM_DATA));
    }

    @Override
    public Map<String, String> parameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.name(), this.value());
        return result;
    }

    @Override
    public String toString() {
        return this.name() + "=" + this.value();
    }
}

