/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.test;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import gnu.trove.list.array.TByteArrayList;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public class ConsoleHandler
implements Serializable,
HttpHandler {
    protected transient SimpleDateFormat m_Formatter;

    protected SimpleDateFormat getFormatter() {
        if (this.m_Formatter == null) {
            this.m_Formatter = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss.SSS");
        }
        return this.m_Formatter;
    }

    @Override
    public void handle(HttpExchange exchange) throws IOException {
        int b;
        StringBuilder output = new StringBuilder();
        output.append("\n--- " + this.getFormatter().format(new Date()) + " ---\n");
        output.append(exchange.getRequestMethod() + " " + exchange.getRequestURI() + " " + exchange.getProtocol()).append("\n");
        output.append("Remote address: " + exchange.getRemoteAddress()).append("\n");
        output.append("Headers:\n");
        for (String key : exchange.getRequestHeaders().keySet()) {
            output.append("- ").append(key).append(": ").append(exchange.getRequestHeaders().get(key)).append("\n");
        }
        TByteArrayList body = new TByteArrayList();
        InputStream in = exchange.getRequestBody();
        while ((b = in.read()) != -1) {
            body.add((byte)b);
        }
        output.append("Body length: " + body.size()).append("\n");
        output.append("Body:\n" + new String(body.toArray()));
        System.out.println(output.toString());
        String response = "OK";
        exchange.getResponseHeaders().add("Server", "requests4j/" + this.getClass().getName());
        exchange.sendResponseHeaders(200, response.length());
        OutputStream os = exchange.getResponseBody();
        os.write(response.getBytes());
        os.close();
    }
}

