/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j;

import com.github.fracpete.requests4j.Requests;
import com.github.fracpete.requests4j.auth.AbstractAuthentication;
import com.github.fracpete.requests4j.auth.NoAuthentication;
import com.github.fracpete.requests4j.event.RequestExecutionEvent;
import com.github.fracpete.requests4j.event.RequestExecutionListener;
import com.github.fracpete.requests4j.event.RequestFailureEvent;
import com.github.fracpete.requests4j.event.RequestFailureListener;
import com.github.fracpete.requests4j.request.Request;
import java.io.Serializable;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.MalformedURLException;
import java.net.URL;
import okhttp3.Authenticator;
import okhttp3.CookieJar;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;

public class Session
implements Serializable,
RequestExecutionListener,
RequestFailureListener {
    protected OkHttpClient m_Client;
    protected CookieManager m_Cookies;
    protected AbstractAuthentication m_Authentication;

    protected Request process(Request request) {
        request.client(this.client());
        request.cookies(this.cookies());
        request.auth(this.auth());
        return request;
    }

    @Override
    public void requestExecuted(RequestExecutionEvent e) {
        e.getRequest().removeExecutionListener(this);
        e.getRequest().removeFailureListener(this);
    }

    @Override
    public void requestFailed(RequestFailureEvent e) {
        e.getRequest().removeExecutionListener(this);
        e.getRequest().removeFailureListener(this);
    }

    public synchronized OkHttpClient client() {
        if (this.m_Client == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)this.cookies()));
            try {
                Authenticator authenticator = this.auth().build();
                if (authenticator != null) {
                    builder.authenticator(authenticator);
                }
            }
            catch (Exception e) {
                System.err.println("Failed to build/set authenticator!");
                e.printStackTrace();
            }
            this.m_Client = builder.build();
        }
        return this.m_Client;
    }

    public CookieManager cookies() {
        if (this.m_Cookies == null) {
            this.m_Cookies = new CookieManager();
            this.m_Cookies.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        }
        return this.m_Cookies;
    }

    public AbstractAuthentication auth() {
        if (this.m_Authentication == null) {
            this.m_Authentication = new NoAuthentication();
        }
        return this.m_Authentication;
    }

    public Request get() {
        return this.process(Requests.get());
    }

    public Request get(String url) throws MalformedURLException {
        return this.process(Requests.get(url));
    }

    public Request get(URL url) {
        return this.process(Requests.get(url));
    }

    public Request post() {
        return this.process(Requests.post());
    }

    public Request post(String url) throws MalformedURLException {
        return this.process(Requests.post(url));
    }

    public Request post(URL url) {
        return this.process(Requests.post(url));
    }

    public Request put() {
        return this.process(Requests.put());
    }

    public Request put(String url) throws MalformedURLException {
        return this.process(Requests.put(url));
    }

    public Request put(URL url) {
        return this.process(Requests.put(url));
    }

    public Request patch() {
        return this.process(Requests.patch());
    }

    public Request patch(String url) throws MalformedURLException {
        return this.process(Requests.patch(url));
    }

    public Request patch(URL url) {
        return this.process(Requests.patch(url));
    }

    public Request head() {
        return this.process(Requests.head());
    }

    public Request head(String url) throws MalformedURLException {
        return this.process(Requests.head(url));
    }

    public Request head(URL url) {
        return this.process(Requests.head(url));
    }

    public Request options() {
        return this.process(Requests.options());
    }

    public Request options(String url) throws MalformedURLException {
        return this.process(Requests.options(url));
    }

    public Request options(URL url) {
        return this.process(Requests.options(url));
    }

    public Request delete() {
        return this.process(Requests.delete());
    }

    public Request delete(String url) throws MalformedURLException {
        return this.process(Requests.delete(url));
    }

    public Request delete(URL url) {
        return this.process(Requests.delete(url));
    }

    public void close() {
    }

    public String toString() {
        return "cookies=" + this.cookies();
    }
}

