/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.core;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;

public class MediaTypeHelper {
    public static final okhttp3.MediaType OCTECT_STREAM = okhttp3.MediaType.parse((String)MediaType.OCTET_STREAM.toString());
    public static final okhttp3.MediaType TEXT_PLAIN = okhttp3.MediaType.parse((String)MediaType.TEXT_PLAIN.toString());
    public static final okhttp3.MediaType APPLICATION_JSON = okhttp3.MediaType.parse((String)"application/json");
    public static final okhttp3.MediaType APPLICATION_JSON_UTF8 = okhttp3.MediaType.parse((String)"application/json; charset=utf-8");

    public static okhttp3.MediaType getMediaType(File file) {
        return okhttp3.MediaType.parse((String)MediaTypeHelper.getMediaType(file.getAbsolutePath()).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static okhttp3.MediaType getMediaType(String filename) {
        FileInputStream fis = null;
        BufferedInputStream bis = null;
        try {
            fis = new FileInputStream(filename);
            bis = new BufferedInputStream(fis);
            AutoDetectParser parser = new AutoDetectParser();
            Detector detector = parser.getDetector();
            Metadata md = new Metadata();
            md.add("resourceName", filename);
            MediaType result = detector.detect((InputStream)bis, md);
            bis.close();
            okhttp3.MediaType mediaType = okhttp3.MediaType.parse((String)result.toString());
            return mediaType;
        }
        catch (Exception e) {
            okhttp3.MediaType mediaType = okhttp3.MediaType.parse((String)MediaType.OCTET_STREAM.toString());
            return mediaType;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (Exception exception) {}
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

