/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.core;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StreamRequestBody
extends RequestBody {
    protected MediaType m_MediaType;
    protected InputStream m_Stream;

    public StreamRequestBody(MediaType mediaType, InputStream stream) {
        this.m_MediaType = mediaType;
        this.m_Stream = stream;
    }

    public long contentLength() throws IOException {
        try {
            return this.m_Stream.available();
        }
        catch (IOException e) {
            return 0L;
        }
    }

    @Nullable
    public MediaType contentType() {
        return this.m_MediaType;
    }

    public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
        Source source = null;
        try {
            source = Okio.source((InputStream)this.m_Stream);
            bufferedSink.writeAll(source);
        }
        finally {
            Util.closeQuietly((Closeable)source);
        }
    }
}

