/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.core;

import com.github.fracpete.requests4j.core.ByteArrayRequestBody;
import okhttp3.MediaType;

public class StringRequestBody
extends ByteArrayRequestBody {
    public StringRequestBody(MediaType mediaType, String data) {
        this(mediaType, data, "UTF-8");
    }

    public StringRequestBody(MediaType mediaType, String data, String charset) {
        super(StringRequestBody.determineMediaType(mediaType, charset), StringRequestBody.toBytes(data, charset));
    }

    protected static MediaType determineMediaType(MediaType mediaType, String charset) {
        String type = mediaType.toString();
        if (type.contains("; charset=")) {
            return MediaType.parse((String)(type.substring(0, type.indexOf(59)) + "; charset=" + charset));
        }
        return MediaType.parse((String)(type + "; charset=" + charset));
    }

    protected static byte[] toBytes(String data, String charset) {
        try {
            return data.getBytes(charset);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to decode '" + data + "' as '" + charset + "'!", e);
        }
    }
}

