/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.form;

import com.github.fracpete.requests4j.core.ByteArrayRequestBody;
import com.github.fracpete.requests4j.form.AbstractParameter;
import java.io.IOException;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class ByteArrayParameter
extends AbstractParameter {
    protected String m_Filename;
    protected MediaType m_MediaType;
    protected byte[] m_Data;

    public ByteArrayParameter(String name, MediaType mediaType, byte[] data) {
        super(name);
        if (data == null) {
            throw new IllegalArgumentException("Byte array cannot be null!");
        }
        this.m_MediaType = mediaType;
        this.m_Data = data;
    }

    @Override
    public boolean canResend() {
        return false;
    }

    public MediaType mediaType() {
        return this.m_MediaType;
    }

    public byte[] data() {
        return this.m_Data;
    }

    @Override
    public void add(MultipartBody.Builder multipart) throws IOException {
        multipart.addFormDataPart(this.name(), null, (RequestBody)new ByteArrayRequestBody(this.m_MediaType, this.m_Data));
    }

    @Override
    public Map<String, String> parameters() {
        throw new IllegalStateException("Byte array parameter only supports POST, not GET!");
    }

    @Override
    public String toString() {
        return this.name() + ", #bytes=" + this.data().length + ", mediatype=" + this.mediaType();
    }
}

