/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.request;

import com.github.fracpete.requests4j.attachment.AbstractAttachment;
import com.github.fracpete.requests4j.auth.AbstractAuthentication;
import com.github.fracpete.requests4j.auth.NoAuthentication;
import com.github.fracpete.requests4j.core.ByteArrayRequestBody;
import com.github.fracpete.requests4j.core.EmptyRequestBody;
import com.github.fracpete.requests4j.core.MediaTypeHelper;
import com.github.fracpete.requests4j.core.Resendable;
import com.github.fracpete.requests4j.core.StringRequestBody;
import com.github.fracpete.requests4j.event.RequestExecutionEvent;
import com.github.fracpete.requests4j.event.RequestExecutionListener;
import com.github.fracpete.requests4j.event.RequestFailureEvent;
import com.github.fracpete.requests4j.event.RequestFailureListener;
import com.github.fracpete.requests4j.form.FormData;
import com.github.fracpete.requests4j.request.Method;
import com.github.fracpete.requests4j.request.URLBuilder;
import com.github.fracpete.requests4j.response.BasicResponse;
import com.github.fracpete.requests4j.response.Response;
import java.io.IOException;
import java.io.Serializable;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Call;
import okhttp3.CookieJar;
import okhttp3.JavaNetCookieJar;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;

public class Request
implements Serializable,
Resendable {
    protected Method m_Method;
    protected URL m_URL;
    protected OkHttpClient m_Client;
    protected boolean m_CloseClient;
    protected CookieManager m_Cookies;
    protected AbstractAuthentication m_Authentication;
    protected Proxy m_Proxy;
    protected Map<String, String> m_Headers;
    protected Map<String, Object> m_Parameters;
    protected Object m_Body;
    protected FormData m_FormData;
    protected AbstractAttachment m_Attachment;
    protected MediaType m_BodyMediaType;
    protected int m_ReadTimeout;
    protected int m_ConnectTimeout;
    protected int m_WriteTimeout;
    protected boolean m_AllowRedirects;
    protected int m_MaxRedirects;
    protected transient Set<RequestExecutionListener> m_ExecutionListeners;
    protected transient Set<RequestFailureListener> m_FailureListeners;
    protected int m_RedirectCount;

    public Request(Method method) {
        this.m_Method = method;
        this.m_URL = null;
        this.m_Client = null;
        this.m_CloseClient = true;
        this.m_Cookies = null;
        this.m_Authentication = new NoAuthentication();
        this.m_Proxy = null;
        this.m_Headers = new HashMap<String, String>();
        this.m_Parameters = new HashMap<String, Object>();
        this.m_Body = null;
        this.m_BodyMediaType = MediaTypeHelper.OCTECT_STREAM;
        this.m_FormData = new FormData();
        this.m_ReadTimeout = -1;
        this.m_ConnectTimeout = -1;
        this.m_WriteTimeout = -1;
        this.m_AllowRedirects = false;
        this.m_MaxRedirects = 3;
        this.m_RedirectCount = 0;
    }

    public Method method() {
        return this.m_Method;
    }

    public Request url(String url) throws MalformedURLException {
        this.m_URL = new URL(url);
        return this;
    }

    public Request url(URL url) {
        this.m_URL = url;
        return this;
    }

    public URL url() {
        return this.m_URL;
    }

    public Request client(OkHttpClient value) {
        this.m_Client = value;
        this.m_CloseClient = false;
        return this;
    }

    public OkHttpClient client() {
        if (this.m_Client == null) {
            OkHttpClient.Builder builder = new OkHttpClient.Builder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)this.cookies())).followRedirects(false);
            try {
                Authenticator authenticator = this.auth().build();
                if (authenticator != null) {
                    builder.authenticator(authenticator);
                }
            }
            catch (Exception e) {
                System.err.println("Failed to build/set authenticator!");
                e.printStackTrace();
            }
            if (this.m_ReadTimeout != -1 || this.m_ConnectTimeout != -1 || this.m_WriteTimeout != -1) {
                if (this.m_ConnectTimeout != -1) {
                    builder.connectTimeout((long)this.m_ConnectTimeout, TimeUnit.SECONDS);
                }
                if (this.m_ReadTimeout != -1) {
                    builder.readTimeout((long)this.m_ReadTimeout, TimeUnit.SECONDS);
                }
                if (this.m_WriteTimeout != -1) {
                    builder.writeTimeout((long)this.m_WriteTimeout, TimeUnit.SECONDS);
                }
            }
            if (this.m_Proxy != null) {
                builder.proxy(this.m_Proxy);
            }
            this.m_Client = builder.build();
        }
        return this.m_Client;
    }

    public Request cookies(CookieManager value) {
        this.m_Cookies = value;
        return this;
    }

    public CookieManager cookies() {
        if (this.m_Cookies == null) {
            this.m_Cookies = new CookieManager();
            this.m_Cookies.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        }
        return this.m_Cookies;
    }

    public Request header(String name, String value) {
        this.m_Headers.put(name, value);
        return this;
    }

    public Request headers(Map<String, String> headers) {
        this.m_Headers.putAll(headers);
        return this;
    }

    public Map<String, String> headers() {
        return this.m_Headers;
    }

    public Request parameter(String name, String value) {
        this.m_Parameters.put(name, value);
        return this;
    }

    public Request parameter(String name, String[] values) {
        this.m_Parameters.put(name, Arrays.asList(values));
        return this;
    }

    public Request parameter(String name, List values) {
        ArrayList<String> strValues = new ArrayList<String>();
        for (Object value : values) {
            strValues.add("" + value);
        }
        this.m_Parameters.put(name, strValues);
        return this;
    }

    public Request parameters(Map<String, Object> parameters) {
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            if (value instanceof String) {
                this.parameter(key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                this.parameter(key, (String[])value);
                continue;
            }
            if (value instanceof List) {
                this.parameter(key, (List)value);
                continue;
            }
            System.err.println("Value of parameter '" + key + "' should be String, String[] or List, but found: " + value.getClass().getName());
        }
        return this;
    }

    public Map<String, Object> parameters() {
        return this.m_Parameters;
    }

    public Request auth(AbstractAuthentication auth) {
        if (auth == null) {
            auth = new NoAuthentication();
        }
        this.m_Authentication = auth;
        return this;
    }

    public AbstractAuthentication auth() {
        return this.m_Authentication;
    }

    public Request proxy(Proxy value) {
        this.m_Proxy = value;
        return this;
    }

    public Request noProxy() {
        this.m_Proxy = null;
        return this;
    }

    public Proxy proxy() {
        return this.m_Proxy;
    }

    public Request body(String value) {
        return this.body(value, MediaTypeHelper.TEXT_PLAIN);
    }

    public Request body(String value, MediaType mediaType) {
        if (!this.m_Method.hasBody()) {
            throw new IllegalArgumentException("Method " + (Object)((Object)this.m_Method) + " does not support a body!");
        }
        this.m_Body = value;
        this.m_BodyMediaType = mediaType;
        return this;
    }

    public Request body(byte[] value) {
        return this.body(value, MediaTypeHelper.OCTECT_STREAM);
    }

    public Request body(byte[] value, MediaType mediaType) {
        if (!this.m_Method.hasBody()) {
            throw new IllegalArgumentException("Method " + (Object)((Object)this.m_Method) + " does not support a body!");
        }
        this.m_Body = value;
        this.m_BodyMediaType = mediaType;
        return this;
    }

    public Object body() {
        return this.m_Body;
    }

    public Request formData(FormData formData) {
        this.m_FormData.putAll(formData);
        return this;
    }

    public FormData formData() {
        return this.m_FormData;
    }

    public Request attachment(AbstractAttachment data) {
        this.m_Attachment = data;
        return this;
    }

    public AbstractAttachment attachment() {
        return this.m_Attachment;
    }

    public Request readTimeout(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ReadTimeout = value;
        return this;
    }

    public int readTimeout() {
        return this.m_ReadTimeout;
    }

    public Request connectTimeout(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_ConnectTimeout = value;
        return this;
    }

    public int connectTimeout() {
        return this.m_ConnectTimeout;
    }

    public Request writeTimeout(int value) {
        if (value < 1) {
            value = -1;
        }
        this.m_WriteTimeout = value;
        return this;
    }

    public int writeTimeout() {
        return this.m_WriteTimeout;
    }

    public Request allowRedirects(boolean allow) {
        this.m_AllowRedirects = allow;
        return this;
    }

    public boolean allowRedirects() {
        return this.m_AllowRedirects;
    }

    public Request maxRedirects(int max) {
        if (max < 0) {
            max = 0;
        }
        this.m_MaxRedirects = max;
        return this;
    }

    public int maxRedirects() {
        return this.m_MaxRedirects;
    }

    public synchronized Request addExecutionListener(RequestExecutionListener l) {
        if (this.m_ExecutionListeners == null) {
            this.m_ExecutionListeners = new HashSet<RequestExecutionListener>();
        }
        this.m_ExecutionListeners.add(l);
        return this;
    }

    public synchronized Request removeExecutionListener(RequestExecutionListener l) {
        if (this.m_ExecutionListeners != null) {
            this.m_ExecutionListeners.remove(l);
        }
        return this;
    }

    protected synchronized void notifyExecutionListeners(RequestExecutionEvent e) {
        if (this.m_ExecutionListeners == null) {
            return;
        }
        for (RequestExecutionListener l : this.m_ExecutionListeners) {
            l.requestExecuted(e);
        }
    }

    public synchronized Request addFailureListener(RequestFailureListener l) {
        if (this.m_FailureListeners == null) {
            this.m_FailureListeners = new HashSet<RequestFailureListener>();
        }
        this.m_FailureListeners.add(l);
        return this;
    }

    public synchronized Request removeFailureListener(RequestFailureListener l) {
        if (this.m_FailureListeners != null) {
            this.m_FailureListeners.remove(l);
        }
        return this;
    }

    protected synchronized void notifyFailureListeners(RequestFailureEvent e) {
        if (this.m_FailureListeners == null) {
            return;
        }
        for (RequestFailureListener l : this.m_FailureListeners) {
            l.requestFailed(e);
        }
    }

    public static boolean isRedirect(int statusCode) {
        return statusCode == 302 || statusCode == 301 || statusCode == 303;
    }

    @Override
    public boolean canResend() {
        boolean result = this.m_FormData.canResend();
        if (result && this.m_Attachment != null) {
            result = this.m_Attachment.canResend();
        }
        return result;
    }

    protected URL assembleURL() throws Exception {
        URL result;
        HashMap<String, Object> params = new HashMap<String, Object>();
        if (this.m_Method != Method.POST) {
            params.putAll(this.m_Parameters);
            params.putAll(this.formData().parameters());
        }
        if (params.size() > 0) {
            URLBuilder builder = new URLBuilder(this.m_URL);
            for (String key : params.keySet()) {
                Object value = params.get(key);
                if (value instanceof List) {
                    builder.append(key, (List)value);
                    continue;
                }
                builder.append(key, "" + value);
            }
            result = new URL(builder.build());
        } else {
            result = this.m_URL;
        }
        return result;
    }

    public BasicResponse execute() throws Exception {
        return this.execute(new BasicResponse());
    }

    protected <T extends Response> T doExecute(T response) throws Exception {
        URL url = this.assembleURL();
        ByteArrayRequestBody body = null;
        try {
            Request.Builder builder = new Request.Builder().url(url);
            switch (this.m_Method) {
                case GET: {
                    builder.get();
                    break;
                }
                case POST: {
                    builder.post((RequestBody)new EmptyRequestBody());
                    break;
                }
                case DELETE: {
                    builder.delete();
                    break;
                }
                case HEAD: {
                    builder.head();
                }
            }
            for (String header : this.headers().keySet()) {
                builder.addHeader(header, this.headers().get(header));
            }
            if (this.m_Method == Method.POST && this.m_FormData.size() > 0) {
                this.m_FormData.add(builder);
            } else if (this.m_Method == Method.POST && this.m_Attachment != null && this.m_Attachment.isValid()) {
                builder.addHeader("Content-Disposition", this.m_Attachment.getContentDisposition());
                builder.post(this.m_Attachment.getBody());
            } else if (this.m_Body != null && this.m_Method.hasBody()) {
                if (this.m_Body instanceof String) {
                    body = new StringRequestBody(this.m_BodyMediaType, (String)this.m_Body);
                } else if (this.m_Body instanceof byte[]) {
                    body = new ByteArrayRequestBody(this.m_BodyMediaType, (byte[])this.m_Body);
                } else {
                    throw new IllegalStateException("Unhandled body type: " + this.m_Body.getClass().getName());
                }
                switch (this.m_Method) {
                    case GET: {
                        builder.method("GET", (RequestBody)body);
                        break;
                    }
                    case POST: {
                        builder.post((RequestBody)body);
                        break;
                    }
                    case PUT: {
                        builder.put((RequestBody)body);
                        break;
                    }
                    case PATCH: {
                        builder.patch((RequestBody)body);
                        break;
                    }
                    case DELETE: {
                        builder.delete((RequestBody)body);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unhandled method: " + (Object)((Object)this.m_Method));
                    }
                }
            }
            okhttp3.Request request = builder.build();
            Call call = this.client().newCall(request);
            okhttp3.Response resp = call.execute();
            response.init(resp);
            try {
                resp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.notifyExecutionListeners(new RequestExecutionEvent(this, response));
            Iterator<String> iterator = response;
            return (T)iterator;
        }
        catch (Throwable t) {
            this.notifyFailureListeners(new RequestFailureEvent(this, t));
            throw t;
        }
        finally {
            this.m_FormData.cleanUp();
        }
    }

    public <T extends Response> T execute(T response) throws Exception {
        response = this.doExecute(response);
        int status = response.statusCode();
        this.m_RedirectCount = 0;
        while (Request.isRedirect(status)) {
            if (!this.m_AllowRedirects) {
                throw new IOException("Received a redirect and no redirects allowed!");
            }
            ++this.m_RedirectCount;
            if (this.m_RedirectCount >= this.m_MaxRedirects) {
                throw new IOException(this.m_MaxRedirects + " redirects were generated when trying to access " + this.m_URL);
            }
            String newURL = (String)response.rawResponse().headers("Location").get(0);
            if (newURL.startsWith("/")) {
                String server = this.m_URL.getProtocol() + "://" + this.m_URL.getHost();
                if (this.m_URL.getPort() != -1) {
                    server = server + ":" + this.m_URL.getPort();
                }
                newURL = server + newURL;
            }
            System.out.println("Redirect, trying to open: " + newURL);
            this.url(newURL);
            response = this.doExecute(response);
            status = response.statusCode();
        }
        return response;
    }
}

