/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.request;

import java.io.Serializable;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class URLBuilder
implements Serializable {
    public static final String ENCODING_UTF8 = "UTF-8";
    protected URL m_URL;
    protected List<String[]> m_Parts;

    public URLBuilder() {
        this(null);
    }

    public URLBuilder(URL url) {
        this.m_URL = url;
        this.m_Parts = new ArrayList<String[]>();
    }

    public URL url() {
        return this.m_URL;
    }

    public URLBuilder append(String key, String value) {
        this.m_Parts.add(new String[]{key, value});
        return this;
    }

    public URLBuilder append(String key, String[] values) {
        for (String value : values) {
            this.m_Parts.add(new String[]{key, value});
        }
        return this;
    }

    public URLBuilder append(String key, Collection values) {
        for (Object value : values) {
            this.m_Parts.add(new String[]{key, "" + value});
        }
        return this;
    }

    public URLBuilder append(Map pairs) {
        for (Object key : pairs.keySet()) {
            Object value = pairs.get(key);
            if (value instanceof String) {
                this.append("" + key, (String)value);
                continue;
            }
            if (value instanceof String[]) {
                this.append("" + key, (String[])value);
                continue;
            }
            if (value instanceof Collection) {
                this.append("" + key, (Collection)value);
                continue;
            }
            throw new IllegalArgumentException("Unhandled value type: " + value.getClass());
        }
        return this;
    }

    public String build() throws Exception {
        return this.build(ENCODING_UTF8);
    }

    public String build(String enc) throws Exception {
        StringBuilder result = new StringBuilder();
        if (this.m_URL != null) {
            result.append(this.m_URL.toString());
        }
        for (int i = 0; i < this.m_Parts.size(); ++i) {
            if (i == 0) {
                result.append("?");
            } else {
                result.append("&");
            }
            String[] part = this.m_Parts.get(i);
            result.append(URLEncoder.encode(part[0], enc));
            result.append("=");
            result.append(URLEncoder.encode(part[1], enc));
        }
        return result.toString();
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> pairs = new HashMap<String, String>();
        pairs.put("m", "m1");
        URL url = new URL("http", "somehost.com", "/api");
        URLBuilder builder = new URLBuilder(url).append("a", "a1").append("b", new String[]{"b1", "b2", "b3"}).append("c", Arrays.asList("c1", "c2")).append(pairs);
        System.out.println(builder.build());
    }
}

