/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.response;

import com.github.fracpete.requests4j.response.Response;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AbstractResponse
implements Serializable,
Response {
    protected okhttp3.Response m_RawResponse = null;
    protected int m_StatusCode = 200;
    protected String m_StatusMessage = "";
    protected Map<String, List<String>> m_Headers = new HashMap<String, List<String>>();

    @Override
    public void init(okhttp3.Response response) {
        this.m_RawResponse = response;
        this.m_StatusCode = response.code();
        this.m_StatusMessage = response.message();
        this.m_Headers.clear();
        for (String header : response.headers().names()) {
            if (!this.m_Headers.containsKey(header)) {
                this.m_Headers.put(header, new ArrayList());
            }
            this.m_Headers.get(header).add(response.header(header));
        }
    }

    @Override
    public okhttp3.Response rawResponse() {
        return this.m_RawResponse;
    }

    @Override
    public Map<String, List<String>> headers() {
        return this.m_Headers;
    }

    @Override
    public int statusCode() {
        return this.m_StatusCode;
    }

    @Override
    public String statusMessage() {
        return this.m_StatusMessage;
    }

    @Override
    public boolean ok() {
        return this.statusCode() < 400;
    }

    public String toString() {
        return "status code: " + this.statusCode() + ", status message: " + this.statusMessage();
    }
}

