/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.attachment;

import com.github.fracpete.requests4j.attachment.AbstractAttachment;
import com.github.fracpete.requests4j.core.ByteArrayRequestBody;
import com.github.fracpete.requests4j.core.MediaTypeHelper;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class ByteArrayAttachment
extends AbstractAttachment {
    protected byte[] m_Content;
    protected MediaType m_MediaType;

    public ByteArrayAttachment(byte[] content) {
        this(content, MediaTypeHelper.OCTECT_STREAM);
    }

    public ByteArrayAttachment(byte[] content, MediaType mediaType) {
        this.m_Content = content;
        this.m_MediaType = mediaType;
    }

    @Override
    public boolean canResend() {
        return true;
    }

    public byte[] content() {
        return this.m_Content;
    }

    public MediaType mediaType() {
        return this.m_MediaType;
    }

    @Override
    public boolean isValid() {
        return this.m_Content != null && this.m_MediaType != null;
    }

    @Override
    public String getContentDisposition() {
        return "attachment";
    }

    @Override
    public RequestBody getBody() {
        return new ByteArrayRequestBody(this.m_MediaType, this.m_Content);
    }

    @Override
    public String toString() {
        return "#bytes=" + (this.content() != null ? this.content().length : 0) + ", mediaType=" + this.mediaType();
    }
}

