/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.attachment;

import com.github.fracpete.requests4j.attachment.AbstractAttachment;
import com.github.fracpete.requests4j.core.FileRequestBody;
import com.github.fracpete.requests4j.core.MediaTypeHelper;
import java.io.File;
import okhttp3.MediaType;
import okhttp3.RequestBody;

public class FileAttachment
extends AbstractAttachment {
    protected File m_File;
    protected String m_Name;
    protected MediaType m_MediaType;

    public FileAttachment(File file) {
        this(file, MediaTypeHelper.OCTECT_STREAM);
    }

    public FileAttachment(File file, MediaType mediaType) {
        this(file, file.getName(), mediaType);
    }

    public FileAttachment(File file, String name, MediaType mediaType) {
        this.m_File = file;
        this.m_Name = name;
        this.m_MediaType = mediaType;
    }

    @Override
    public boolean canResend() {
        return true;
    }

    public File file() {
        return this.m_File;
    }

    public String name() {
        return this.m_Name;
    }

    public MediaType mediaType() {
        return this.m_MediaType;
    }

    @Override
    public boolean isValid() {
        return this.m_File != null && this.m_File.exists() && !this.m_File.isDirectory() && this.m_Name != null && this.m_MediaType != null;
    }

    @Override
    public String getContentDisposition() {
        return "attachment; name=\"file\"; filename=\"" + this.m_Name + "\"";
    }

    @Override
    public RequestBody getBody() {
        return new FileRequestBody(this.m_MediaType, this.m_File.getAbsolutePath());
    }

    @Override
    public String toString() {
        return "file=" + this.file() + ", name=" + this.name() + ", mediaType=" + this.mediaType();
    }
}

