/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.core;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.internal.Util;
import okio.BufferedSink;
import okio.Okio;
import okio.Source;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileRequestBody
extends RequestBody {
    protected MediaType m_MediaType;
    protected String m_Filename;

    public FileRequestBody(MediaType mediaType, String filename) {
        this.m_MediaType = mediaType;
        this.m_Filename = filename;
    }

    public long contentLength() throws IOException {
        try {
            return new File(this.m_Filename).length();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Nullable
    public MediaType contentType() {
        return this.m_MediaType;
    }

    public void writeTo(@NotNull BufferedSink bufferedSink) throws IOException {
        Source source = null;
        try {
            source = Okio.source((File)new File(this.m_Filename));
            bufferedSink.writeAll(source);
        }
        catch (Throwable throwable) {
            Util.closeQuietly(source);
            throw throwable;
        }
        Util.closeQuietly((Closeable)source);
    }
}

