/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.form;

import com.github.fracpete.requests4j.form.AbstractParameter;
import com.github.fracpete.requests4j.json.Array;
import com.github.fracpete.requests4j.json.Dictionary;
import com.github.fracpete.requests4j.json.Element;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MultipartBody;

public class JsonParameter
extends AbstractParameter {
    protected Element m_Value;

    public JsonParameter(String name, Dictionary value) {
        super(name);
        if (value == null) {
            throw new IllegalStateException("String parameter value cannot be null (name=" + name + ")!");
        }
        this.m_Value = value;
    }

    public JsonParameter(String name, Array value) {
        super(name);
        if (value == null) {
            throw new IllegalStateException("String parameter value cannot be null (name=" + name + ")!");
        }
        this.m_Value = value;
    }

    @Override
    public boolean canResend() {
        return true;
    }

    public String value() {
        return this.m_Value.dump();
    }

    @Override
    public void add(MultipartBody.Builder multipart) throws IOException {
        multipart.addFormDataPart(this.name(), this.value());
    }

    @Override
    public Map<String, String> parameters() {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put(this.name(), this.value());
        return result;
    }

    @Override
    public String toString() {
        return this.name() + "=" + this.value();
    }
}

