/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.form;

import com.github.fracpete.requests4j.core.FileRequestBody;
import com.github.fracpete.requests4j.core.MediaTypeHelper;
import com.github.fracpete.requests4j.core.StreamRequestBody;
import com.github.fracpete.requests4j.form.AbstractParameter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class StreamParameter
extends AbstractParameter {
    protected String m_Filename;
    protected MediaType m_MediaType;
    protected InputStream m_Stream;

    public StreamParameter(String name, String filename) {
        this(name, filename, MediaType.parse((String)MediaTypeHelper.getMediaType(filename).toString()), null);
    }

    public StreamParameter(String name, File file) {
        this(name, file.getAbsolutePath(), MediaType.parse((String)MediaTypeHelper.getMediaType(file).toString()), null);
    }

    public StreamParameter(String name, File file, MediaType mediaType, InputStream stream) {
        this(name, file.getAbsolutePath(), mediaType, stream);
    }

    public StreamParameter(String name, String filename, MediaType mediaType, InputStream stream) {
        super(name);
        this.m_Filename = filename;
        this.m_MediaType = mediaType;
        this.m_Stream = stream;
    }

    @Override
    public boolean canResend() {
        return this.m_Stream == null;
    }

    public String filename() {
        return this.m_Filename;
    }

    public MediaType mediaType() {
        return this.m_MediaType;
    }

    public InputStream stream() {
        return this.m_Stream;
    }

    @Override
    public void add(MultipartBody.Builder multipart) throws IOException {
        if (this.m_Stream != null) {
            multipart.addFormDataPart(this.name(), null, (RequestBody)new StreamRequestBody(this.m_MediaType, this.stream()));
        } else {
            multipart.addFormDataPart(this.name(), null, (RequestBody)new FileRequestBody(this.m_MediaType, this.filename()));
        }
    }

    @Override
    public Map<String, String> parameters() {
        throw new IllegalStateException("File/Stream parameter only supports POST, not GET!");
    }

    @Override
    public String toString() {
        return this.name() + ", filename=" + this.filename() + ", media type=" + this.mediaType();
    }
}

