/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.json;

import com.github.fracpete.requests4j.json.Array;
import com.github.fracpete.requests4j.json.Element;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Set;

public class Dictionary
extends Element<JsonObject> {
    public Dictionary() {
        this.m_Data = new JsonObject();
    }

    public Dictionary(JsonObject dict) {
        this.m_Data = dict;
    }

    public Dictionary(String json) {
        this();
        Gson gson = new Gson();
        this.m_Data = (JsonElement)gson.fromJson(json, JsonObject.class);
    }

    public Dictionary add(String key, char value) {
        ((JsonObject)this.m_Data).addProperty(key, Character.valueOf(value));
        return this;
    }

    public Dictionary add(String key, String value) {
        ((JsonObject)this.m_Data).addProperty(key, value);
        return this;
    }

    public Dictionary add(String key, byte value) {
        ((JsonObject)this.m_Data).addProperty(key, (Number)value);
        return this;
    }

    public Dictionary add(String key, short value) {
        ((JsonObject)this.m_Data).addProperty(key, (Number)value);
        return this;
    }

    public Dictionary add(String key, int value) {
        ((JsonObject)this.m_Data).addProperty(key, (Number)value);
        return this;
    }

    public Dictionary add(String key, long value) {
        ((JsonObject)this.m_Data).addProperty(key, (Number)value);
        return this;
    }

    public Dictionary add(String key, float value) {
        ((JsonObject)this.m_Data).addProperty(key, (Number)Float.valueOf(value));
        return this;
    }

    public Dictionary add(String key, double value) {
        ((JsonObject)this.m_Data).addProperty(key, (Number)value);
        return this;
    }

    public Dictionary add(String key, boolean value) {
        ((JsonObject)this.m_Data).addProperty(key, Boolean.valueOf(value));
        return this;
    }

    public Dictionary add(String key, Dictionary value) {
        ((JsonObject)this.m_Data).add(key, value.toJson());
        return this;
    }

    public Dictionary add(String key, Array value) {
        ((JsonObject)this.m_Data).add(key, value.toJson());
        return this;
    }

    public Set<String> keySet() {
        return ((JsonObject)this.m_Data).keySet();
    }

    public JsonElement get(String key) {
        return ((JsonObject)this.m_Data).get(key);
    }

    public static Dictionary newDict() {
        return new Dictionary();
    }

    public static Dictionary parse(String json) {
        return new Dictionary(json);
    }
}

