/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.requests4j.response;

import com.github.fracpete.requests4j.request.Request;
import com.github.fracpete.requests4j.response.AbstractResponse;
import gnu.trove.list.TByteList;
import gnu.trove.list.array.TByteArrayList;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import okhttp3.Response;

public class BasicResponse
extends AbstractResponse {
    protected TByteList m_Body = new TByteArrayList();

    @Override
    public void init(Response response) {
        super.init(response);
        if (!Request.isRedirect(response.code())) {
            this.m_Body.clear();
            if (response.body() != null) {
                try {
                    int b;
                    InputStream in = response.body().byteStream();
                    while ((b = in.read()) != -1) {
                        this.m_Body.add((byte)b);
                    }
                }
                catch (Exception e) {
                    System.err.println("Failed to read response body!");
                }
            }
        }
    }

    public byte[] body() {
        return this.m_Body.toArray();
    }

    public String text() throws UnsupportedEncodingException {
        return this.text("UTF-8");
    }

    public String text(String encoding) throws UnsupportedEncodingException {
        return new String(this.body(), encoding);
    }

    public void saveBody(String filename) throws IOException {
        this.saveBody(new File(filename));
    }

    public void saveBody(File file) throws IOException {
        Files.write(file.toPath(), this.body(), StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Override
    public String toString() {
        return super.toString() + ", body length: " + this.body().length;
    }
}

