/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.resourceextractor4j;

import com.github.fracpete.resourceextractor4j.IOUtils;
import gnu.trove.list.array.TByteArrayList;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Content {
    protected static Logger LOGGER = Logger.getLogger(Content.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(String resource) {
        ArrayList<String> result = new ArrayList<String>();
        InputStream in = null;
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String line;
            in = Content.class.getClassLoader().getResourceAsStream(resource);
            isr = new InputStreamReader(in);
            br = new BufferedReader(isr);
            while ((line = br.readLine()) != null) {
                result.add(line);
            }
        }
        catch (Exception e) {
            List<String> list;
            try {
                LOGGER.log(Level.SEVERE, "Failed to read lines from resource file: " + resource, e);
                list = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(br);
                IOUtils.closeQuietly(isr);
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(br);
            IOUtils.closeQuietly(isr);
            IOUtils.closeQuietly(in);
            return list;
        }
        IOUtils.closeQuietly(br);
        IOUtils.closeQuietly(isr);
        IOUtils.closeQuietly(in);
        return result;
    }

    public static String readString(String resource) {
        byte[] bytes = Content.readBytes(resource);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to read string from resource file: " + resource, e);
            return null;
        }
    }

    public static String readString(String resource, Charset charset) {
        byte[] bytes = Content.readBytes(resource);
        if (bytes == null) {
            return null;
        }
        try {
            return new String(bytes, charset);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, "Failed to read string (" + charset + ") from resource file: " + resource, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(String resource) {
        TByteArrayList result = new TByteArrayList();
        InputStream in = null;
        byte[] buffer = new byte[4096];
        try {
            int read;
            in = Content.class.getClassLoader().getResourceAsStream(resource);
            while ((read = in.read(buffer)) > 0) {
                result.add(buffer, 0, read);
            }
        }
        catch (Exception e) {
            byte[] byArray;
            try {
                LOGGER.log(Level.SEVERE, "Failed to read bytes from resource file: " + resource, e);
                byArray = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
            return byArray;
        }
        IOUtils.closeQuietly(in);
        return result.toArray();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String resource) {
        Properties result = new Properties();
        InputStream in = null;
        try {
            in = Content.class.getClassLoader().getResourceAsStream(resource);
            result.load(in);
        }
        catch (Exception e) {
            Properties properties;
            try {
                LOGGER.log(Level.SEVERE, "Failed to read properties from resource file: " + resource, e);
                properties = null;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(in);
                throw throwable;
            }
            IOUtils.closeQuietly(in);
            return properties;
        }
        IOUtils.closeQuietly(in);
        return result;
    }
}

