/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.resourceextractor4j;

import com.github.fracpete.resourceextractor4j.IOUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Files {
    protected static Logger LOGGER = Logger.getLogger(Files.class.getName());

    public static void extractTo(String inDir, List<String> files, String outDir) throws Exception {
        for (String file : files) {
            File currentFile = new File(file);
            String currentInDir = currentFile.getParent();
            String currentName = currentFile.getName();
            try {
                File currentOutDir = new File(outDir + "/" + (currentInDir == null ? "" : currentInDir));
                if (!currentOutDir.exists()) {
                    currentOutDir.mkdirs();
                }
                Files.extractTo(inDir + "/" + (currentInDir == null ? "" : currentInDir), currentName, currentOutDir.getAbsolutePath());
            }
            catch (Exception e) {
                String msg = "Failed to copy '" + file + "' from '" + inDir + "' to '" + outDir + "'!";
                LOGGER.log(Level.SEVERE, msg, e);
                throw new IOException(msg, e);
            }
        }
    }

    public static String extractTo(String inDir, String name, String outDir) throws Exception {
        String result = null;
        InputStream is = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            String resource = inDir;
            if (!resource.endsWith("/")) {
                resource = resource + "/";
            }
            resource = resource + name;
            String outFull = outDir + File.separator + name;
            LOGGER.info("Copying resource '" + resource + "' to '" + outFull + "'");
            is = Files.class.getClassLoader().getResourceAsStream(resource);
            bis = new BufferedInputStream(is);
            File out = new File(outFull);
            fos = new FileOutputStream(out);
            bos = new BufferedOutputStream(fos);
            IOUtils.copy(bis, bos);
            result = out.getAbsolutePath();
        }
        catch (Exception e) {
            try {
                String msg = "Failed to copy '" + name + "' from '" + inDir + "' to '" + outDir + "'!";
                LOGGER.log(Level.SEVERE, msg, e);
                throw new IOException(msg, e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly(bis);
        IOUtils.closeQuietly(is);
        IOUtils.closeQuietly(bos);
        IOUtils.closeQuietly(fos);
        return result;
    }
}

