/*
 * Decompiled with CFR 0.152.
 */
package de.dentrassi.rpm.builder;

import de.dentrassi.rpm.builder.Logger;
import de.dentrassi.rpm.builder.Signature;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.eclipse.packager.security.pgp.PgpHelper;

public final class SigningHelper {
    private SigningHelper() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static PGPPrivateKey loadKey(Signature signature, Logger logger) throws MojoFailureException, MojoExecutionException {
        if (signature == null) {
            return null;
        }
        if (signature.isSkip()) {
            return null;
        }
        if (signature.getKeyId() == null) throw new MojoFailureException((Object)signature, "'keyId' parameter not set", "Signing requires the 'keyId' to the user id of the GPG key to use.");
        if (signature.getKeyId().isEmpty()) {
            throw new MojoFailureException((Object)signature, "'keyId' parameter not set", "Signing requires the 'keyId' to the user id of the GPG key to use.");
        }
        if (signature.getKeyringFile() == null) {
            throw new MojoFailureException((Object)signature, "'keyringFile' parameter not set", "Signing requires the 'keyringFile' to be set to a valid GPG keyring file, containing the secret keys.");
        }
        if (signature.getPassphrase() == null) {
            throw new MojoFailureException((Object)signature, "'passphrase' parameter not set", "Signing requires the 'passphrase' parameter to be set.");
        }
        try (FileInputStream input = new FileInputStream(signature.getKeyringFile());){
            PGPPrivateKey privateKey = PgpHelper.loadPrivateKey((InputStream)input, (String)signature.getKeyId(), (String)signature.getPassphrase());
            if (privateKey == null) {
                throw new MojoFailureException(String.format("Unable to load GPG key '%s' from '%s'", signature.getKeyId(), signature.getKeyringFile()));
            }
            logger.info("Signing RPM - keyId: %016x", privateKey.getKeyID());
            PGPPrivateKey pGPPrivateKey = privateKey;
            return pGPPrivateKey;
        }
        catch (IOException | PGPException e) {
            throw new MojoExecutionException("Failed to load private key for signing", (Exception)e);
        }
    }
}

