/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.rsync4j;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;

public class Binaries {
    public static final String RESOURCE_DIR = "com/github/fracpete/rsync4j/";
    public static final String WINDOWS_DIR = "windows-x86_64/";
    protected static Boolean binariesExtracted;
    protected static String rsyncBinary;
    protected static String sshBinary;
    protected static Logger LOGGER;

    public static synchronized int getBitness() {
        String arch = System.getProperty("os.arch");
        if (arch.endsWith("86")) {
            return 32;
        }
        if (arch.endsWith("64")) {
            return 64;
        }
        throw new IllegalStateException("Cannot interpret 'os.arch' for bitness: " + arch);
    }

    protected static String copyResourceTo(String inDir, String name, String outDir) throws Exception {
        String result = null;
        InputStream is = null;
        BufferedInputStream bis = null;
        FileOutputStream fos = null;
        BufferedOutputStream bos = null;
        try {
            String resource = inDir;
            if (!resource.endsWith("/")) {
                resource = resource + "/";
            }
            resource = resource + name;
            String outFull = outDir + File.separator + name;
            LOGGER.info("Copying resource '" + resource + "' to '" + outFull + "'");
            is = ClassLoader.getSystemResourceAsStream(resource);
            bis = new BufferedInputStream(is);
            File out = new File(outFull);
            fos = new FileOutputStream(out);
            bos = new BufferedOutputStream(fos);
            IOUtils.copy((InputStream)bis, (OutputStream)bos);
            result = out.getAbsolutePath();
        }
        catch (Exception e) {
            try {
                LOGGER.log(Level.SEVERE, "Copying failed!", e);
                throw e;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bis);
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(bos);
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)bis);
        IOUtils.closeQuietly((InputStream)is);
        IOUtils.closeQuietly((OutputStream)bos);
        IOUtils.closeQuietly((OutputStream)fos);
        return result;
    }

    protected static void extractBinaries() throws Exception {
        if (Binaries.getBitness() != 64) {
            throw new IllegalStateException("Only 64bit is supported!");
        }
        sshBinary = "/usr/bin/ssh";
        rsyncBinary = "/usr/bin/rsync";
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC_OSX) {
            if (!new File(rsyncBinary).exists()) {
                throw new IllegalStateException("rsync not installed (" + rsyncBinary + ")?");
            }
            if (!new File(sshBinary).exists()) {
                throw new IllegalStateException("ssh not installed (" + sshBinary + ")?");
            }
        } else if (SystemUtils.IS_OS_WINDOWS) {
            String homeDir = System.getProperty("user.home") + File.separator + "rsync4j";
            String binDir = homeDir + File.separator + "bin";
            String sshDir = homeDir + File.separator + "home" + File.separator + System.getProperty("user.name") + File.separator + ".ssh";
            if (!new File(binDir + File.separator + "rsync.exe").exists()) {
                LOGGER.info("Setting up rsync4j environment in '" + homeDir + "'...");
                File dir = new File(binDir);
                if (!dir.exists()) {
                    LOGGER.info("Creating directory: " + dir);
                    if (!dir.mkdirs()) {
                        throw new IllegalStateException("Failed to create directory: " + dir);
                    }
                }
                if (!(dir = new File(sshDir)).exists()) {
                    LOGGER.info("Creating directory: " + dir);
                    if (!dir.mkdirs()) {
                        throw new IllegalStateException("Failed to create directory: " + dir);
                    }
                }
                LOGGER.info("Copy your public key pairs into: " + dir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cygcom_err-2.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cygcrypto-1.0.0.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cyggcc_s-seh-1.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cyggssapi_krb5-2.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cygiconv-2.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cygintl-8.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cygk5crypto-3.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cygkrb5-3.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cygkrb5support-0.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cygssp-0.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cygwin1.dll", binDir);
                Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "cygz.dll", binDir);
                sshBinary = Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "ssh.exe", binDir);
                rsyncBinary = Binaries.copyResourceTo("com/github/fracpete/rsync4j/windows-x86_64/", "rsync.exe", binDir);
            } else {
                sshBinary = binDir + File.separator + "ssh.exe";
                rsyncBinary = binDir + File.separator + "rsync.exe";
            }
        } else {
            throw new IllegalStateException("Unsupported operating system: " + SystemUtils.OS_NAME + "/" + SystemUtils.OS_ARCH + "/" + SystemUtils.OS_VERSION);
        }
        binariesExtracted = true;
    }

    public static String rsyncBinary() throws Exception {
        if (binariesExtracted == null) {
            Binaries.extractBinaries();
        }
        return rsyncBinary;
    }

    public static String sshBinary() throws Exception {
        if (binariesExtracted == null) {
            Binaries.extractBinaries();
        }
        return sshBinary;
    }

    public static String convertPath(String path) {
        String result = path;
        if (SystemUtils.IS_OS_WINDOWS && (result = result.replace("\\", "/")).matches("^[a-zA-Z]:.*")) {
            result = "/cygdrive/" + result.substring(0, 1).toLowerCase() + "/" + result.substring(2);
        }
        return result;
    }

    static {
        LOGGER = Logger.getLogger(Binaries.class.getName());
    }
}

