/*
 * Decompiled with CFR 0.152.
 */
package com.github.fracpete.simpleini4j;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.builder.BuilderParameters;
import org.apache.commons.configuration2.builder.FileBasedConfigurationBuilder;
import org.apache.commons.configuration2.builder.fluent.HierarchicalBuilderParameters;
import org.apache.commons.configuration2.builder.fluent.Parameters;
import org.apache.commons.configuration2.tree.DefaultExpressionEngine;
import org.apache.commons.configuration2.tree.DefaultExpressionEngineSymbols;
import org.apache.commons.configuration2.tree.ExpressionEngine;
import org.apache.commons.configuration2.tree.NodeMatcher;
import org.apache.commons.configuration2.tree.NodeNameMatchers;

public class INIFile
implements Serializable {
    private static final long serialVersionUID = -751900803366565452L;
    protected INIConfiguration m_Configuration;

    public INIFile() {
        this(new INIConfiguration());
    }

    public INIFile(String filename) {
        this(INIFile.readConfig(filename));
    }

    public INIFile(File file) {
        this(INIFile.readConfig(file.getAbsolutePath()));
    }

    public INIFile(INIConfiguration configuration) {
        if (configuration == null) {
            throw new IllegalArgumentException("Configuration cannot be null!");
        }
        this.m_Configuration = configuration;
    }

    public List<String> getSections() {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(this.m_Configuration.getSections());
        Collections.sort(result);
        return result;
    }

    protected void isValid(String section, String key) {
        if (section.contains(".")) {
            throw new IllegalArgumentException("Section name cannot contain dots!");
        }
        if (key.contains(".")) {
            throw new IllegalArgumentException("Key cannot contain dots!");
        }
    }

    public boolean has(String section, String key) {
        this.isValid(section, key);
        return this.m_Configuration.getProperty(section + "." + key) != null;
    }

    public void set(String section, String key, Object value) {
        this.isValid(section, key);
        this.m_Configuration.setProperty(section + "." + key, value);
    }

    public Object get(String section, String key) {
        this.isValid(section, key);
        return this.m_Configuration.getBoolean(section + "." + key);
    }

    public boolean getBoolean(String section, String key) {
        this.isValid(section, key);
        return this.m_Configuration.getBoolean(section + "." + key);
    }

    public String getString(String section, String key) {
        this.isValid(section, key);
        return this.m_Configuration.getString(section + "." + key);
    }

    public byte getByte(String section, String key) {
        this.isValid(section, key);
        return this.m_Configuration.getByte(section + "." + key);
    }

    public short getShort(String section, String key) {
        this.isValid(section, key);
        return this.m_Configuration.getShort(section + "." + key);
    }

    public int getInt(String section, String key) {
        this.isValid(section, key);
        return this.m_Configuration.getInt(section + "." + key);
    }

    public long getLong(String section, String key) {
        this.isValid(section, key);
        return this.m_Configuration.getLong(section + "." + key);
    }

    public float getFloat(String section, String key) {
        this.isValid(section, key);
        return this.m_Configuration.getFloat(section + "." + key);
    }

    public double getDouble(String section, String key) {
        this.isValid(section, key);
        return this.m_Configuration.getDouble(section + "." + key);
    }

    public void remove(String section, String key) {
        this.isValid(section, key);
        this.m_Configuration.getSection(section).clearTree(key);
    }

    public void remove(String section) {
        this.isValid(section, "");
        this.m_Configuration.clearTree(section);
    }

    public String toString() {
        StringWriter swriter = new StringWriter();
        try {
            this.m_Configuration.write((Writer)swriter);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to turn configuration into string!");
        }
        return swriter.toString();
    }

    public static INIFile read(String filename) {
        INIConfiguration config = INIFile.readConfig(filename);
        if (config == null) {
            return null;
        }
        return new INIFile(config);
    }

    public static INIConfiguration readConfig(String filename) {
        File file = new File(filename);
        if (!file.exists()) {
            return null;
        }
        DefaultExpressionEngine engine = new DefaultExpressionEngine(DefaultExpressionEngineSymbols.DEFAULT_SYMBOLS, (NodeMatcher)NodeNameMatchers.EQUALS_IGNORE_CASE);
        Parameters params = new Parameters();
        FileBasedConfigurationBuilder builder = new FileBasedConfigurationBuilder(INIConfiguration.class).configure(new BuilderParameters[]{(BuilderParameters)((HierarchicalBuilderParameters)params.hierarchical().setFileName(filename)).setExpressionEngine((ExpressionEngine)engine)});
        try {
            return (INIConfiguration)builder.getConfiguration();
        }
        catch (Exception e) {
            System.err.println("Failed to parse: " + filename);
            e.printStackTrace();
            return null;
        }
    }

    public String write(File file) {
        return this.write(file.getAbsolutePath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String write(String filename) {
        String string;
        FileWriter fwriter = null;
        BufferedWriter bwriter = null;
        File file = new File(filename);
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            return "Failed to create directory for configuration file: " + dir;
        }
        try {
            fwriter = new FileWriter(file);
            bwriter = new BufferedWriter(fwriter);
            this.m_Configuration.write((Writer)bwriter);
            string = null;
        }
        catch (Exception e) {
            String string2;
            try {
                System.err.println("Failed to write configuration to: " + file);
                e.printStackTrace();
                string2 = "Failed to write configuration to: " + file + "\n" + e;
            }
            catch (Throwable throwable) {
                INIFile.closeQuietly(bwriter);
                INIFile.closeQuietly(fwriter);
                throw throwable;
            }
            INIFile.closeQuietly(bwriter);
            INIFile.closeQuietly(fwriter);
            return string2;
        }
        INIFile.closeQuietly(bwriter);
        INIFile.closeQuietly(fwriter);
        return string;
    }

    protected static void closeQuietly(Writer writer) {
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                writer.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

