/*
 * Decompiled with CFR 0.152.
 */
package sizeof.agent;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;

public class SizeOfAgent {
    static Instrumentation inst;
    static Boolean messageDisplayed;

    public static void premain(String agentArgs, Instrumentation instP) {
        inst = instP;
    }

    public static long sizeOf(Object o) {
        if (inst == null) {
            if (messageDisplayed == null) {
                messageDisplayed = true;
                System.err.println("Can not access instrumentation environment.\nPlease check if jar file containing SizeOfAgent class is \nspecified in the java's \"-javaagent\" command line argument.");
            }
            return 0L;
        }
        return inst.getObjectSize(o);
    }

    public static long fullSizeOf(Object obj) {
        IdentityHashMap<Object, Object> visited = new IdentityHashMap<Object, Object>();
        Stack<Object> stack = new Stack<Object>();
        long result = SizeOfAgent.internalSizeOf(obj, stack, visited);
        while (!stack.isEmpty()) {
            result += SizeOfAgent.internalSizeOf(stack.pop(), stack, visited);
        }
        visited.clear();
        return result;
    }

    private static boolean skipObject(Object obj, Map<Object, Object> visited) {
        if (obj instanceof String && obj == ((String)obj).intern()) {
            return true;
        }
        return obj == null || visited.containsKey(obj);
    }

    private static long internalSizeOf(Object obj, Stack<Object> stack, Map<Object, Object> visited) {
        Class<?> clazz;
        if (SizeOfAgent.skipObject(obj, visited)) {
            return 0L;
        }
        visited.put(obj, null);
        long result = 0L;
        result += SizeOfAgent.sizeOf(obj);
        if (clazz.isArray()) {
            if (clazz.getName().length() != 2) {
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    stack.add(Array.get(obj, i));
                }
            }
            return result;
        }
        for (clazz = obj.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                if (Modifier.isStatic(fields[i].getModifiers()) || fields[i].getType().isPrimitive()) continue;
                try {
                    fields[i].setAccessible(true);
                    try {
                        Object objectToAdd = fields[i].get(obj);
                        if (objectToAdd == null) continue;
                        stack.add(objectToAdd);
                        continue;
                    }
                    catch (IllegalAccessException ex) {
                        if ($assertionsDisabled) continue;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        return result;
    }
}

