/*
 * Decompiled with CFR 0.152.
 */
package sizeof.agent;

import java.lang.instrument.Instrumentation;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Stack;
import sizeof.agent.Filter;
import sizeof.agent.Statistics;

public class SizeOfAgent {
    static Instrumentation inst;
    static Boolean messageDisplayed;

    public static void premain(String agentArgs, Instrumentation instP) {
        inst = instP;
    }

    public static long sizeOf(Object o) {
        if (inst == null) {
            if (messageDisplayed == null) {
                messageDisplayed = true;
                System.err.println("Can not access instrumentation environment.\nPlease check if jar file containing SizeOfAgent class is \nspecified in the java's \"-javaagent\" command line argument.");
            }
            return 0L;
        }
        return inst.getObjectSize(o);
    }

    public static long fullSizeOf(Object obj) {
        return SizeOfAgent.fullSizeOf(obj, null);
    }

    public static long fullSizeOf(Object obj, Filter filter) {
        IdentityHashMap<Object, Object> visited = new IdentityHashMap<Object, Object>();
        Stack<Object> stack = new Stack<Object>();
        long result = SizeOfAgent.internalSizeOf(obj, stack, visited, null, null);
        while (!stack.isEmpty()) {
            result += SizeOfAgent.internalSizeOf(stack.pop(), stack, visited, null, filter);
        }
        visited.clear();
        return result;
    }

    public static Map<Class, Statistics> fullSizePerClass(Object obj) {
        return SizeOfAgent.fullSizePerClass(obj, null);
    }

    public static Map<Class, Statistics> fullSizePerClass(Object obj, Filter filter) {
        HashMap<Class, Statistics> perClass = new HashMap<Class, Statistics>();
        IdentityHashMap<Object, Object> visited = new IdentityHashMap<Object, Object>();
        Stack<Object> stack = new Stack<Object>();
        SizeOfAgent.internalSizeOf(obj, stack, visited, perClass, null);
        while (!stack.isEmpty()) {
            SizeOfAgent.internalSizeOf(stack.pop(), stack, visited, perClass, filter);
        }
        visited.clear();
        return perClass;
    }

    private static boolean skipObject(Object obj, Map<Object, Object> visited, Filter filter) {
        if (obj == null) {
            return true;
        }
        if (obj instanceof String && obj == ((String)obj).intern()) {
            return true;
        }
        if (filter != null && filter.skipObject(obj)) {
            return true;
        }
        return visited.containsKey(obj);
    }

    private static long internalSizeOf(Object obj, Stack<Object> stack, Map<Object, Object> visited, Map<Class, Statistics> perClass, Filter filter) {
        Class<?> clazz;
        if (SizeOfAgent.skipObject(obj, visited, filter)) {
            return 0L;
        }
        visited.put(obj, null);
        long result = 0L;
        result += SizeOfAgent.sizeOf(obj);
        if (perClass != null) {
            Class<?> cls = obj.getClass();
            if (!perClass.containsKey(cls)) {
                perClass.put(cls, new Statistics());
            }
            ++perClass.get(cls).count;
            perClass.get(cls).total += result;
        }
        if ((clazz = obj.getClass()).isArray()) {
            if (!clazz.getComponentType().isPrimitive()) {
                int length = Array.getLength(obj);
                for (int i = 0; i < length; ++i) {
                    stack.add(Array.get(obj, i));
                }
            }
            return result;
        }
        while (clazz != null) {
            for (Field field : clazz.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getType().isPrimitive() || filter != null && filter.skipField(field)) continue;
                try {
                    field.setAccessible(true);
                    try {
                        Object objectToAdd = field.get(obj);
                        if (objectToAdd == null) continue;
                        stack.add(objectToAdd);
                    }
                    catch (IllegalAccessException ex) {
                        if ($assertionsDisabled) continue;
                        throw new AssertionError();
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            clazz = clazz.getSuperclass();
            if (filter == null || !filter.skipSuperClass(clazz)) continue;
            clazz = null;
        }
        return result;
    }
}

