/*
 * Decompiled with CFR 0.152.
 */
package org.cservenak.streams;

import java.io.IOException;
import java.io.OutputStream;
import org.cservenak.streams.Coder;
import org.cservenak.streams.CoderThread;

public class CoderOutputStream
extends OutputStream {
    private final CoderThread ct;
    private OutputStream out;

    protected CoderOutputStream(OutputStream out, Coder coder) throws IOException {
        this.ct = new CoderThread(coder, out);
        this.out = this.ct.getOutputStreamSink();
        this.ct.start();
    }

    @Override
    public void write(int b) throws IOException {
        this.out.write(b);
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        if ((off | len | b.length - (len + off) | off + len) < 0) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        this.out.close();
        try {
            this.ct.join();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        this.ct.checkForException();
    }
}

