/*
 * This file is part of the LIRE project: http://www.semanticmetadata.net/lire
 * LIRE is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * LIRE is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LIRE; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * We kindly ask you to refer the any or one of the following publications in
 * any publication mentioning or employing Lire:
 *
 * Lux Mathias, Savvas A. Chatzichristofis. Lire: Lucene Image Retrieval –
 * An Extensible Java CBIR Library. In proceedings of the 16th ACM International
 * Conference on Multimedia, pp. 1085-1088, Vancouver, Canada, 2008
 * URL: http://doi.acm.org/10.1145/1459359.1459577
 *
 * Lux Mathias. Content Based Image Retrieval with LIRE. In proceedings of the
 * 19th ACM International Conference on Multimedia, pp. 735-738, Scottsdale,
 * Arizona, USA, 2011
 * URL: http://dl.acm.org/citation.cfm?id=2072432
 *
 * Mathias Lux, Oge Marques. Visual Information Retrieval using Java and LIRE
 * Morgan & Claypool, 2013
 * URL: http://www.morganclaypool.com/doi/abs/10.2200/S00468ED1V01Y201301ICR025
 *
 * Copyright statement:
 * --------------------
 * (c) 2002-2013 by Mathias Lux (mathias@juggle.at)
 *     http://www.semanticmetadata.net/lire, http://www.lire-project.net
 */

package net.semanticmetadata.lire.imageanalysis.filters;

public final class IndexedIntArray
{
    public int[] array;
    public int index;
    
    
    public IndexedIntArray(int[] array, int idx)
    {
        if (array == null)
           throw new NullPointerException("The array cannot be null");
        
        this.array = array;
        this.index = idx;
    }
    
    
    @Override
    public boolean equals(Object o)
    {
        try
        {
            if (o == null)
               return false;

            if (this == o)
               return true;

            IndexedIntArray iba = (IndexedIntArray) o;
            return ((this.array == iba.array) && (this.index == iba.index));
        }
        catch (ClassCastException e)
        {
            return false;
        }
    }
        

    @Override
    public int hashCode()
    {
       // Non constant !
       return this.index + ((this.array == null) ? 0 :(17 * this.array.hashCode()));
    }


    @Override
    public String toString()
    {
        StringBuilder builder = new StringBuilder(100);
        builder.append("[");
        builder.append(String.valueOf(this.array));
        builder.append(","); 
        builder.append(this.index); 
        builder.append("]"); 
        return builder.toString();
    }
}
