/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.classifiers;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import javax.imageio.ImageIO;
import net.semanticmetadata.lire.DocumentBuilder;
import net.semanticmetadata.lire.ImageSearchHits;
import net.semanticmetadata.lire.imageanalysis.ColorLayout;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.impl.BitSamplingImageSearcher;
import net.semanticmetadata.lire.impl.GenericFastImageSearcher;
import net.semanticmetadata.lire.indexing.tools.Extractor;
import net.semanticmetadata.lire.utils.SerializationUtils;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.MMapDirectory;
import weka.attributeSelection.ASEvaluation;
import weka.attributeSelection.ASSearch;
import weka.attributeSelection.AttributeSelection;
import weka.attributeSelection.InfoGainAttributeEval;
import weka.attributeSelection.Ranker;
import weka.core.Instances;

public class HashingSearchBasedClassifierMod {
    public static void main(String[] args) throws IOException, IllegalAccessException, InstantiationException, ClassNotFoundException {
        String[] pathes = new String[]{"D:\\Datasets\\Fashion10000RunItemImproved\\"};
        for (int r = 0; r < pathes.length; ++r) {
            int i;
            double informationGainThreshold = 0.22;
            int numberOfCombinations = 12;
            int numberOfNeighbours = 16;
            double precisionThreshold = 1.0;
            String pathName = pathes[r];
            boolean useIndexSearch = true;
            String locationSaveResultsFile = pathName + System.currentTimeMillis() + "_IG" + informationGainThreshold + "_NC" + numberOfCombinations + "_NN" + numberOfNeighbours + "_" + "run.txt";
            String locationOfIndex = pathName + "idx\\index";
            String testIndexLocation = "D:\\Datasets\\FashionTestItemDataSet\\idx\\index";
            String testImageLocation = "D:\\Datasets\\FashionTestItemDataSet\\";
            String locationOfImages = pathName;
            String locationOfTrainSet = pathName + "train.txt";
            String locationExtracorFile = pathName + "indexall.data";
            String locationOfTestset = pathName + "test.txt";
            String[] fieldsArray = new String[]{"CEDD", "EdgeHistogram", "FCTH", "ColorLayout", "PHOG", "JCD", "Gabor", "JpegCoeffs", "Tamura", "Luminance_Layout", "Opponent_Histogram", "ScalableColor"};
            String[] classArray = new String[]{"CEDD", "EdgeHistogram", "FCTH", "ColorLayout", "PHOG", "JCD", "Gabor", "JpegCoefficientHistogram", "Tamura", "LuminanceLayout", "OpponentHistogram", "ScalableColor"};
            int[] featureSpace = new int[classArray.length];
            double[] featuresInformationGain = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
            FileInputStream inf = new FileInputStream(locationExtracorFile);
            byte[] tempIntf = new byte[4];
            byte[] tempf = new byte[102400];
            int tmpf = ((InputStream)inf).read(tempIntf, 0, 4);
            if (tmpf > 0) {
                tmpf = SerializationUtils.toInt(tempIntf);
                ((InputStream)inf).read(tempf, 0, tmpf);
                while (((InputStream)inf).read(tempIntf, 0, 1) > 0 && tempIntf[0] != -1) {
                    byte tmpFeaturef = tempIntf[0];
                    LireFeature f = (LireFeature)Class.forName(Extractor.features[tmpFeaturef]).newInstance();
                    ((InputStream)inf).read(tempIntf, 0, 4);
                    tmpf = SerializationUtils.toInt(tempIntf);
                    ((InputStream)inf).read(tempf, 0, tmpf);
                    f.setByteArrayRepresentation(tempf, 0, tmpf);
                    for (int z = 0; z < classArray.length; ++z) {
                        if (!f.getClass().getSimpleName().equals(classArray[z])) continue;
                        featureSpace[z] = f.getDoubleHistogram().length;
                    }
                }
            }
            HashMap<String, Integer> featureSpaceHashMap = new HashMap<String, Integer>(classArray.length);
            for (int d = 0; d < classArray.length; ++d) {
                featureSpaceHashMap.put(classArray[d], featureSpace[d]);
            }
            HashMap<String, Double> featureInformationGainHashMap = new HashMap<String, Double>(classArray.length);
            for (int d = 0; d < classArray.length; ++d) {
                featureInformationGainHashMap.put(classArray[d], 0.0);
            }
            String class1 = "yes";
            String class2 = "no";
            ArrayList<String> reducedFieldsArray = new ArrayList<String>();
            ArrayList<String> reducedClassArray = new ArrayList<String>();
            double maxInfoGain = 0.0;
            double minInfoGain = 1000.0;
            for (int i2 = 0; i2 < classArray.length; ++i2) {
                if ((Double)featureInformationGainHashMap.get(classArray[i2]) > maxInfoGain) {
                    maxInfoGain = (Double)featureInformationGainHashMap.get(classArray[i2]);
                }
                if (!((Double)featureInformationGainHashMap.get(classArray[i2]) < minInfoGain)) continue;
                minInfoGain = (Double)featureInformationGainHashMap.get(classArray[i2]);
            }
            double infoGainAvg = 0.0;
            for (i = 0; i < classArray.length; ++i) {
                infoGainAvg += ((Double)featureInformationGainHashMap.get(classArray[i]) - minInfoGain) / (maxInfoGain - minInfoGain);
            }
            infoGainAvg = infoGainAvg / (double)classArray.length / 2.0;
            for (i = 0; i < classArray.length; ++i) {
                reducedFieldsArray.add(fieldsArray[i]);
                reducedClassArray.add(classArray[i]);
            }
            if (numberOfCombinations > reducedClassArray.size()) {
                numberOfCombinations = reducedClassArray.size();
            }
            System.out.println("Features reduced! Starting with classification. Reduced Feature Set: " + reducedClassArray.toString());
            try {
                if (!useIndexSearch) continue;
                HashingSearchBasedClassifierMod.testClassifyNCombinedFeaturesMulti(0, 220, locationSaveResultsFile, numberOfNeighbours, locationOfIndex, testIndexLocation, locationOfImages, locationOfTestset, 0, reducedFieldsArray, reducedClassArray, numberOfCombinations, class1, class2, informationGainThreshold, "TestSet", precisionThreshold, classArray, testImageLocation);
                continue;
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
                continue;
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
                continue;
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                continue;
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
        }
    }

    public static boolean testClassifyNCombinedFeaturesMulti(int start, int end, String storeToFile, int numberOfNeighbours, String indexLocation, String testIndexLocation, String photosLocation, String testSetFile, int searchedClass, ArrayList<String> fieldsArray, ArrayList<String> classArray, int combineNfeatures, String class1, String class2, double informationGainThreshold, String useIndex, double precisionThreshold, String[] allClasses, String testImageLocation) throws IOException, NoSuchFieldException, IllegalAccessException, ClassNotFoundException, InstantiationException {
        int i;
        int feats = fieldsArray.size();
        int combs = combineNfeatures;
        PrintWriter print_line = new PrintWriter(new BufferedWriter(new FileWriter(storeToFile)));
        ArrayList combinations = HashingSearchBasedClassifierMod.print_nCr(feats, combs);
        String sCombinedFeatures = "";
        for (int i2 = 0; i2 < allClasses.length; ++i2) {
            sCombinedFeatures = sCombinedFeatures + "Feature" + i2 + 1 + ";";
        }
        print_line.print(sCombinedFeatures + "K=;IGTH;PRTH;Weight Rank=;Class;Precision;Recall;True Negative Rate;Accuracy;False Positive Rate;F-Measure;MCC;WFM;Count Test Images;Count Correct;ms per test;TP;FP;TN;FN");
        print_line.println();
        print_line.flush();
        ArrayList<String> fields1List = new ArrayList<String>();
        ArrayList<String> class1List = new ArrayList<String>();
        for (i = 0; i < combinations.size(); i += combs) {
            for (int j = 0; j < combs; ++j) {
                int x = (Integer)combinations.get(i + j) - 1;
                fields1List.add(fieldsArray.get(x));
                class1List.add(classArray.get(x));
            }
        }
        for (i = 0; i < combinations.size(); i += combs) {
            int j;
            int j2;
            ArrayList<String> featureNameList = new ArrayList<String>();
            ArrayList<LireFeature> lireFeatureList = new ArrayList<LireFeature>();
            ArrayList<String> indexLocationList = new ArrayList<String>();
            ArrayList<String> testIndexLocationList = new ArrayList<String>();
            ArrayList<DirectoryReader> indexReaderList = new ArrayList<DirectoryReader>();
            ArrayList<DirectoryReader> indexReaderTestList = new ArrayList<DirectoryReader>();
            ArrayList<BitSamplingImageSearcher> bisSearcherList = new ArrayList<BitSamplingImageSearcher>();
            ArrayList<ImageSearchHits> imageSearchHitsList = new ArrayList<ImageSearchHits>();
            ArrayList tag2countList = new ArrayList();
            ArrayList tag2weightList = new ArrayList();
            for (int j3 = 0; j3 < combs; ++j3) {
                featureNameList.add((String)DocumentBuilder.class.getField("FIELD_NAME_" + ((String)fields1List.get(i + j3)).toUpperCase()).get(null));
                lireFeatureList.add((LireFeature)Class.forName("net.semanticmetadata.lire.imageanalysis." + (String)class1List.get(i + j3)).newInstance());
                indexLocationList.add(indexLocation + (String)class1List.get(i + j3));
                testIndexLocationList.add(testIndexLocation + (String)class1List.get(i + j3));
            }
            boolean weightByRank = true;
            boolean createHTML = true;
            String[] classes = new String[]{class1, class2};
            int k = numberOfNeighbours;
            HashMap<String, Integer> tag2count = new HashMap<String, Integer>(k);
            HashMap<String, Double> tag2weight = new HashMap<String, Double>(k);
            int c = 0;
            c = searchedClass;
            String classIdentifier = classes[c];
            ArrayList<String> classesHTML = new ArrayList<String>();
            ArrayList<String> filesHTML = new ArrayList<String>();
            for (j2 = 0; j2 < combs; ++j2) {
                indexReaderList.add(DirectoryReader.open((Directory)MMapDirectory.open((File)new File((String)indexLocationList.get(j2)))));
                indexReaderTestList.add(DirectoryReader.open((Directory)MMapDirectory.open((File)new File((String)testIndexLocationList.get(j2) + "TestSet"))));
            }
            for (j2 = 0; j2 < combs; ++j2) {
                bisSearcherList.add(new BitSamplingImageSearcher(k, (String)featureNameList.get(j2), (String)featureNameList.get(j2) + "_hash", (LireFeature)lireFeatureList.get(j2), 1000));
            }
            int count = 0;
            int countCorrect = 0;
            double countTp = 0.0;
            double countFp = 0.0;
            double countTn = 0.0;
            double countFn = 0.0;
            long ms = System.currentTimeMillis();
            for (int x = 0; x < ((IndexReader)indexReaderTestList.get(0)).numDocs(); ++x) {
                int j4;
                tag2count.clear();
                tag2weight.clear();
                tag2weightList.clear();
                tag2countList.clear();
                tag2count.put(class1, 1);
                tag2count.put(class2, 1);
                tag2weight.put(class1, 1.0);
                tag2weight.put(class2, 1.0);
                for (j4 = 0; j4 < combs; ++j4) {
                    imageSearchHitsList.add(((BitSamplingImageSearcher)bisSearcherList.get(j4)).search(((IndexReader)indexReaderTestList.get(j4)).document(x), (IndexReader)indexReaderList.get(j4)));
                }
                for (j4 = 0; j4 < combs; ++j4) {
                    tag2countList.add(new HashMap(k));
                    ((HashMap)tag2countList.get(j4)).put(class1, 1);
                    ((HashMap)tag2countList.get(j4)).put(class2, 1);
                    tag2weightList.add(new HashMap(k));
                    ((HashMap)tag2weightList.get(j4)).put(class1, 1.0);
                    ((HashMap)tag2weightList.get(j4)).put(class2, 1.0);
                }
                for (int l = 0; l < k; ++l) {
                    int j5;
                    try {
                        for (j5 = 0; j5 < combs; ++j5) {
                            tag2count.put(HashingSearchBasedClassifierMod.getTag(((ImageSearchHits)imageSearchHitsList.get(j5)).doc(l), photosLocation), (Integer)tag2count.get(HashingSearchBasedClassifierMod.getTag(((ImageSearchHits)imageSearchHitsList.get(j5)).doc(l), photosLocation)) + 1);
                            ((HashMap)tag2countList.get(j5)).put(HashingSearchBasedClassifierMod.getTag(((ImageSearchHits)imageSearchHitsList.get(j5)).doc(l), photosLocation), (Integer)((HashMap)tag2countList.get(j5)).get(HashingSearchBasedClassifierMod.getTag(((ImageSearchHits)imageSearchHitsList.get(j5)).doc(l), photosLocation)) + 1);
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        // empty catch block
                    }
                    try {
                        if (!weightByRank) continue;
                        for (j5 = 0; j5 < combs; ++j5) {
                            tag2weight.put(HashingSearchBasedClassifierMod.getTag(((ImageSearchHits)imageSearchHitsList.get(j5)).doc(l), photosLocation), (Double)tag2weight.get(HashingSearchBasedClassifierMod.getTag(((ImageSearchHits)imageSearchHitsList.get(j5)).doc(l), photosLocation)) + 1.0 / ((double)l + 1.0));
                            ((HashMap)tag2weightList.get(j5)).put(HashingSearchBasedClassifierMod.getTag(((ImageSearchHits)imageSearchHitsList.get(j5)).doc(l), photosLocation), (Double)((HashMap)tag2weightList.get(j5)).get(HashingSearchBasedClassifierMod.getTag(((ImageSearchHits)imageSearchHitsList.get(j5)).doc(l), photosLocation)) + 1.0 / ((double)l + 1.0));
                        }
                        continue;
                    }
                    catch (IndexOutOfBoundsException e) {
                        // empty catch block
                    }
                }
                imageSearchHitsList.clear();
                boolean maxCount = false;
                boolean maxima = false;
                int countClass1 = 0;
                int countClass2 = 0;
                double weightClass1 = 0.0;
                double weightClass2 = 0.0;
                String classifiedAs = null;
                for (String tag : ((HashMap)tag2countList.get(0)).keySet()) {
                    for (int j6 = 0; j6 < combs; ++j6) {
                        if (tag.equals(class1)) {
                            countClass1 += ((Integer)((HashMap)tag2countList.get(j6)).get(tag)).intValue();
                            weightClass1 += ((Double)((HashMap)tag2weightList.get(j6)).get(tag)).doubleValue();
                        }
                        if (!tag.equals(class2)) continue;
                        countClass2 += ((Integer)((HashMap)tag2countList.get(j6)).get(tag)).intValue();
                        weightClass2 += ((Double)((HashMap)tag2weightList.get(j6)).get(tag)).doubleValue();
                    }
                }
                classifiedAs = (double)countClass1 * weightClass1 * precisionThreshold > (double)countClass2 * weightClass2 ? class1 : class2;
                ++count;
                classesHTML.add(classifiedAs);
                filesHTML.add(((IndexReader)indexReaderTestList.get(0)).document(x).getField("descriptorImageIdentifier").stringValue());
                if (classifiedAs.equals(HashingSearchBasedClassifierMod.getTag(((IndexReader)indexReaderTestList.get(0)).document(x), testImageLocation)) && classifiedAs.equals(class1)) {
                    ++countCorrect;
                    countTp += 1.0;
                } else if (!classifiedAs.equals(HashingSearchBasedClassifierMod.getTag(((IndexReader)indexReaderTestList.get(0)).document(x), testImageLocation)) && classifiedAs.equals(class1)) {
                    countFp += 1.0;
                }
                if (classifiedAs.equals(HashingSearchBasedClassifierMod.getTag(((IndexReader)indexReaderTestList.get(0)).document(x), testImageLocation)) && classifiedAs.equals(class2)) {
                    ++countCorrect;
                    countTn += 1.0;
                } else if (!classifiedAs.equals(HashingSearchBasedClassifierMod.getTag(((IndexReader)indexReaderTestList.get(0)).document(x), testImageLocation)) && classifiedAs.equals(class2)) {
                    countFn += 1.0;
                }
                print_line.println(classifiedAs);
            }
            print_line.flush();
            double precisicon = HashingSearchBasedClassifierMod.getPrecision(countTp, countFp);
            double recall = HashingSearchBasedClassifierMod.getRecall(countTp, countFn);
            double trueNegativeRate = HashingSearchBasedClassifierMod.getTrueNegativeRate(countTn, countFp);
            double accuracy = HashingSearchBasedClassifierMod.getAccuracy(countTp, countFp, countTn, countFn);
            double fMeasure = HashingSearchBasedClassifierMod.getFmeasure(precisicon, recall);
            double falsePositiveRate = HashingSearchBasedClassifierMod.getFalsePositiveRate(countFp, countTn);
            double mccMeasure = HashingSearchBasedClassifierMod.getMccMeasure(countTp, countFp, countTn, countFn);
            double wFM = HashingSearchBasedClassifierMod.getWFM(countTp, countFp, countTn, countFn, fMeasure, count);
            String classesLongName = "";
            for (j = 0; j < combs; ++j) {
                classesLongName = classesLongName + (String)fields1List.get(i + j) + ";";
            }
            for (j = 0; j < allClasses.length - combs; ++j) {
                classesLongName = classesLongName + "no;";
            }
            System.out.printf("%s%s;%s;%s;%s;%s;%4.5f;%4.5f;%4.5f;%4.5f;%4.5f;%4.5f;%4.5f;%4.5f;%10d;%10d;%4d;%4.5f;%4.5f;%4.5f;%4.5f\n", classesLongName, k, informationGainThreshold, precisionThreshold, weightByRank, classIdentifier, precisicon, recall, trueNegativeRate, accuracy, falsePositiveRate, fMeasure, mccMeasure, wFM, count, countCorrect, (System.currentTimeMillis() - ms) / (long)count, countTp, countFp, countTn, countFn);
            print_line.printf("%s%s;%s;%s;%s;%s;%4.5f;%4.5f;%4.5f;%4.5f;%4.5f;%4.5f;%4.5f;%4.5f;%10d;%10d;%4d;%4.5f;%4.5f;%4.5f;%4.5f\n", classesLongName, k, informationGainThreshold, precisionThreshold, weightByRank, classIdentifier, precisicon, recall, trueNegativeRate, accuracy, falsePositiveRate, fMeasure, mccMeasure, wFM, count, countCorrect, (System.currentTimeMillis() - ms) / (long)count, countTp, countFp, countTn, countFn);
            print_line.flush();
            if (!createHTML) continue;
            String fileName = "classifieresults-" + System.currentTimeMillis() / 1000L + ".html";
            BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
            bw.write("<html>\n<head><title>Classification Results</title></head>\n<body bgcolor=\"#FFFFFF\">\n");
            bw.write("<table>");
            int elems = filesHTML.size();
            for (int d = 0; d < elems; ++d) {
                if (d % 3 == 0) {
                    bw.write("<tr>");
                }
                String s = (String)filesHTML.get(d);
                String colorF = "rgb(0, 255, 0)";
                if (((String)classesHTML.get(d)).equals("no")) {
                    colorF = "rgb(255, 0, 0)";
                }
                bw.write("<td><a href=\"" + s + "\"><img style=\"max-width:220px;border:medium solid " + colorF + ";\"src=\"" + s + "\" border=\"" + 5 + "\" style=\"border: 3px\n" + "black solid;\"></a></td>\n");
                if (d % 3 != 2) continue;
                bw.write("</tr>");
            }
            if (elems % 3 != 0) {
                if (elems % 3 == 2) {
                    bw.write("<td>-</td with exit code 0\nd>\n");
                    bw.write("<td>-</td>\n");
                } else if (elems % 3 == 2) {
                    bw.write("<td>-</td>\n");
                }
                bw.write("</tr>");
            }
            bw.write("</table></body>\n</html>");
            bw.close();
        }
        print_line.close();
        return true;
    }

    public void testClassify() throws IOException {
        String line;
        boolean weightByRank = true;
        String[] classes = new String[]{"2012", "beach", "food", "london", "music", "nature", "people", "sky", "travel", "wedding"};
        int k = 50;
        String photosLocation = "D:\\Datasets\\FashionTestItemDataSet\\";
        String fieldName = "descriptorColorLayout";
        ColorLayout feature = new ColorLayout();
        String indexPath = "E:\\acmgc-cl-idx";
        System.out.println("Tests for feature " + fieldName + " with k=" + k + " - weighting by rank sum: " + weightByRank);
        System.out.println("========================================");
        HashMap<String, Integer> tag2count = new HashMap<String, Integer>(k);
        HashMap<String, Double> tag2weight = new HashMap<String, Double>(k);
        int c = 9;
        String classIdentifier = classes[c];
        String listFiles = "D:\\DataSets\\Yahoo-GC\\test\\" + classIdentifier + ".txt";
        int[] confusion = new int[10];
        Arrays.fill(confusion, 0);
        HashMap<String, Integer> class2id = new HashMap<String, Integer>(10);
        for (int i = 0; i < classes.length; ++i) {
            class2id.put(classes[i], i);
        }
        BufferedReader br = new BufferedReader(new FileReader(listFiles));
        DirectoryReader ir = DirectoryReader.open((Directory)MMapDirectory.open((File)new File(indexPath)));
        BitSamplingImageSearcher bis = new BitSamplingImageSearcher(k, fieldName, fieldName + "_hash", (LireFeature)feature, 1000);
        int count = 0;
        int countCorrect = 0;
        long ms = System.currentTimeMillis();
        while ((line = br.readLine()) != null) {
            try {
                tag2count.clear();
                tag2weight.clear();
                ImageSearchHits hits = bis.search(ImageIO.read(new File(line)), (IndexReader)ir);
                for (int l = 0; l < k; ++l) {
                    String tag = HashingSearchBasedClassifierMod.getTag(hits.doc(l), photosLocation);
                    if (tag2count.get(tag) == null) {
                        tag2count.put(tag, 1);
                    } else {
                        tag2count.put(tag, (Integer)tag2count.get(tag) + 1);
                    }
                    if (weightByRank) {
                        if (tag2weight.get(tag) == null) {
                            tag2weight.put(tag, Double.valueOf(l));
                            continue;
                        }
                        tag2weight.put(tag, (double)l + (Double)tag2weight.get(tag));
                        continue;
                    }
                    if (tag2weight.get(tag) == null) {
                        tag2weight.put(tag, Double.valueOf(hits.score(l)));
                        continue;
                    }
                    tag2weight.put(tag, (double)l + (double)hits.score(l));
                }
                int maxCount = 0;
                int maxima = 0;
                String classifiedAs = null;
                for (String tag : tag2count.keySet()) {
                    if ((Integer)tag2count.get(tag) > maxCount) {
                        maxCount = (Integer)tag2count.get(tag);
                        maxima = 1;
                        classifiedAs = tag;
                        continue;
                    }
                    if ((Integer)tag2count.get(tag) != maxCount) continue;
                    ++maxima;
                }
                if (maxima > 1) {
                    double minWeight = Double.MAX_VALUE;
                    for (String tag : tag2count.keySet()) {
                        if (!((Double)tag2weight.get(tag) < minWeight)) continue;
                        minWeight = (Double)tag2weight.get(tag);
                        classifiedAs = tag;
                    }
                }
                ++count;
                if (classifiedAs.equals(classIdentifier)) {
                    ++countCorrect;
                }
                int n = (Integer)class2id.get(classifiedAs);
                confusion[n] = confusion[n] + 1;
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
            }
        }
        System.out.printf("Class\tAvg. Precision\tCount Test Images\tms per test\n", new Object[0]);
        System.out.printf("%s\t%4.5f\t%10d\t%4d\n", classIdentifier, (double)countCorrect / (double)count, count, (System.currentTimeMillis() - ms) / (long)count);
        System.out.printf("Confusion\t", new Object[0]);
        for (int i = 0; i < classes.length; ++i) {
            System.out.printf("%d\t", confusion[i]);
        }
        System.out.println();
    }

    public static boolean testClassifyFashionThreeCombinedFeaturesMulti(int start, int end, String storeToFile) throws IOException {
        PrintWriter print_line = new PrintWriter(new BufferedWriter(new FileWriter(storeToFile)));
        String[] fieldsArray = new String[]{"CEDD", "EdgeHistogram", "FCTH", "ColorLayout", "PHOG", "JCD", "Gabor", "JpegCoeffs", "Tamura", "Luminance_Layout", "Opponent_Histogram", "ScalableColor"};
        String[] classArray = new String[]{"CEDD", "EdgeHistogram", "FCTH", "ColorLayout", "PHOG", "JCD", "Gabor", "JpegCoefficientHistogram", "Tamura", "LuminanceLayout", "OpponentHistogram", "ScalableColor"};
        print_line.print("Feature1;Feature2;Feature3;K=;Weight Rank=;Class;Precision;Recall;True Negative Rate;Accuracy;False Positive Rate;F-Measure;Count Test Images;Count Correct;ms per test;TP;FP;TN;FN");
        print_line.println();
        print_line.flush();
        ArrayList<String> fields1List = new ArrayList<String>();
        ArrayList<String> fields2List = new ArrayList<String>();
        ArrayList<String> fields3List = new ArrayList<String>();
        ArrayList<String> class1List = new ArrayList<String>();
        ArrayList<String> class2List = new ArrayList<String>();
        ArrayList<String> class3List = new ArrayList<String>();
        for (int g = 0; g < fieldsArray.length; ++g) {
            for (int h = g + 1; h < fieldsArray.length; ++h) {
                for (int f = h + 1; f < fieldsArray.length; ++f) {
                    fields1List.add(fieldsArray[g]);
                    fields2List.add(fieldsArray[h]);
                    fields3List.add(fieldsArray[f]);
                    class1List.add(classArray[g]);
                    class2List.add(classArray[h]);
                    class3List.add(classArray[f]);
                }
            }
        }
        for (int y = start; y < end; ++y) {
            String line;
            String fS1 = (String)class1List.get(y);
            String fS2 = (String)class2List.get(y);
            String fS3 = (String)class3List.get(y);
            String fN1 = "FIELD_NAME_" + ((String)fields1List.get(y)).toUpperCase();
            String fN2 = "FIELD_NAME_" + ((String)fields2List.get(y)).toUpperCase();
            String fN3 = "FIELD_NAME_" + ((String)fields3List.get(y)).toUpperCase();
            boolean weightByRank = true;
            boolean createHTML = false;
            String[] classes = new String[]{"yes", "no"};
            int k = 3;
            String indexLocation = "D:\\Datasets\\FashionTestItemDataSet\\idx\\index";
            String photosLocation = "D:\\Datasets\\FashionTestItemDataSet\\";
            String listFiles = "D:\\Datasets\\FashionTestItemDataSet\\itemtest.txt";
            String f1 = null;
            String f2 = null;
            String f3 = null;
            try {
                f1 = (String)DocumentBuilder.class.getField(fN1).get(null);
                f2 = (String)DocumentBuilder.class.getField(fN2).get(null);
                f3 = (String)DocumentBuilder.class.getField(fN3).get(null);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            LireFeature lf1 = null;
            LireFeature lf2 = null;
            LireFeature lf3 = null;
            try {
                lf1 = (LireFeature)Class.forName("net.semanticmetadata.lire.imageanalysis." + fS1).newInstance();
                lf2 = (LireFeature)Class.forName("net.semanticmetadata.lire.imageanalysis." + fS2).newInstance();
                lf3 = (LireFeature)Class.forName("net.semanticmetadata.lire.imageanalysis." + fS3).newInstance();
            }
            catch (InstantiationException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            String i1 = indexLocation + fS1;
            String i2 = indexLocation + fS2;
            String i3 = indexLocation + fS3;
            HashMap<String, Integer> tag2count = new HashMap<String, Integer>(k);
            HashMap<String, Double> tag2weight = new HashMap<String, Double>(k);
            int c = 0;
            String classIdentifier = classes[c];
            ArrayList<String> classesHTML = new ArrayList<String>();
            ArrayList<String> filesHTML = new ArrayList<String>();
            int[] confusion = new int[2];
            Arrays.fill(confusion, 0);
            HashMap<String, Integer> class2id = new HashMap<String, Integer>(2);
            for (int i = 0; i < classes.length; ++i) {
                class2id.put(classes[i], i);
            }
            BufferedReader br = new BufferedReader(new FileReader(listFiles));
            DirectoryReader ir1 = DirectoryReader.open((Directory)MMapDirectory.open((File)new File(i1)));
            DirectoryReader ir2 = DirectoryReader.open((Directory)MMapDirectory.open((File)new File(i2)));
            DirectoryReader ir3 = DirectoryReader.open((Directory)MMapDirectory.open((File)new File(i3)));
            GenericFastImageSearcher bis1 = new GenericFastImageSearcher(k, lf1.getClass(), f1, true, (IndexReader)ir1);
            GenericFastImageSearcher bis2 = new GenericFastImageSearcher(k, lf2.getClass(), f2, true, (IndexReader)ir2);
            GenericFastImageSearcher bis3 = new GenericFastImageSearcher(k, lf3.getClass(), f3, true, (IndexReader)ir3);
            int count = 0;
            int countCorrect = 0;
            double countTp = 0.0;
            double countFp = 0.0;
            double countTn = 0.0;
            double countFn = 0.0;
            long ms = System.currentTimeMillis();
            while ((line = br.readLine()) != null) {
                try {
                    tag2count.clear();
                    tag2weight.clear();
                    tag2count.put("yes", 1);
                    tag2count.put("no", 1);
                    tag2weight.put("yes", 1.0);
                    tag2weight.put("no", 1.0);
                    ImageSearchHits hits1 = bis1.search(ImageIO.read(new File(line)), (IndexReader)ir1);
                    ImageSearchHits hits2 = bis2.search(ImageIO.read(new File(line)), (IndexReader)ir2);
                    ImageSearchHits hits3 = bis3.search(ImageIO.read(new File(line)), (IndexReader)ir3);
                    for (int l = 0; l < k; ++l) {
                        String tag = HashingSearchBasedClassifierMod.getTag(hits1.doc(l), photosLocation);
                        String tagSecond = HashingSearchBasedClassifierMod.getTag(hits2.doc(l), photosLocation);
                        String tagThird = HashingSearchBasedClassifierMod.getTag(hits3.doc(l), photosLocation);
                        tag2count.put(tag, (Integer)tag2count.get(tag) + 1);
                        tag2count.put(tagSecond, (Integer)tag2count.get(tagSecond) + 1);
                        tag2count.put(tagThird, (Integer)tag2count.get(tagThird) + 1);
                        if (weightByRank) {
                            if (tag2weight.get(tag) == null && tag2weight.get(tagSecond) == null && tag2weight.get(tagThird) == null) {
                                tag2weight.put(tag, Double.valueOf(l));
                                tag2weight.put(tagSecond, Double.valueOf(l));
                                tag2weight.put(tagThird, Double.valueOf(l));
                                continue;
                            }
                            if (tag2weight.get(tag) != null && tag2weight.get(tagSecond) != null && tag2weight.get(tagThird) != null) {
                                tag2weight.put(tag, (double)l + (Double)tag2weight.get(tag));
                                tag2weight.put(tagSecond, (double)l + (Double)tag2weight.get(tagSecond));
                                tag2weight.put(tagThird, (double)l + (Double)tag2weight.get(tagThird));
                                continue;
                            }
                            if (tag2weight.get(tag) != null && tag2weight.get(tagSecond) != null && tag2weight.get(tagThird) == null) {
                                tag2weight.put(tag, (double)l + (Double)tag2weight.get(tag));
                                tag2weight.put(tagSecond, (double)l + (Double)tag2weight.get(tagSecond));
                                tag2weight.put(tagThird, Double.valueOf(l));
                                continue;
                            }
                            if (tag2count.get(tag) != null && tag2count.get(tagSecond) == null && tag2weight.get(tagThird) != null) {
                                tag2weight.put(tag, (double)l + (Double)tag2weight.get(tag));
                                tag2weight.put(tagSecond, Double.valueOf(l));
                                tag2weight.put(tagThird, (double)l + (Double)tag2weight.get(tagThird));
                                continue;
                            }
                            if (tag2count.get(tag) != null || tag2count.get(tagSecond) == null || tag2weight.get(tagThird) == null) continue;
                            tag2weight.put(tag, Double.valueOf(l));
                            tag2weight.put(tagSecond, (double)l + (Double)tag2weight.get(tagSecond));
                            tag2weight.put(tagThird, (double)l + (Double)tag2weight.get(tagThird));
                            continue;
                        }
                        if (tag2weight.get(tag) == null) {
                            if (Double.valueOf(hits1.score(l)) > Double.valueOf(hits2.score(l)) && Double.valueOf(hits1.score(l)) > Double.valueOf(hits3.score(l))) {
                                tag2weight.put(tag, Double.valueOf(hits1.score(l)));
                                continue;
                            }
                            if (Double.valueOf(hits2.score(l)) > Double.valueOf(hits1.score(l)) && Double.valueOf(hits2.score(l)) > Double.valueOf(hits3.score(l))) {
                                tag2weight.put(tagSecond, Double.valueOf(hits2.score(l)));
                                continue;
                            }
                            if (!(Double.valueOf(hits3.score(l)) > Double.valueOf(hits1.score(l))) || !(Double.valueOf(hits3.score(l)) > Double.valueOf(hits2.score(l)))) continue;
                            tag2weight.put(tagThird, Double.valueOf(hits3.score(l)));
                            continue;
                        }
                        if (Double.valueOf(hits1.score(l)) > Double.valueOf(hits2.score(l)) && Double.valueOf(hits1.score(l)) > Double.valueOf(hits3.score(l))) {
                            tag2weight.put(tag, (double)l + (double)hits1.score(l));
                            continue;
                        }
                        if (Double.valueOf(hits2.score(l)) > Double.valueOf(hits1.score(l)) && Double.valueOf(hits2.score(l)) > Double.valueOf(hits3.score(l))) {
                            tag2weight.put(tagSecond, (double)l + (double)hits2.score(l));
                            continue;
                        }
                        if (!(Double.valueOf(hits3.score(l)) > Double.valueOf(hits1.score(l))) || !(Double.valueOf(hits3.score(l)) > Double.valueOf(hits2.score(l)))) continue;
                        tag2weight.put(tagThird, Double.valueOf(hits3.score(l)));
                    }
                    int maxCount = 0;
                    int maxima = 0;
                    String classifiedAs = null;
                    for (String tag : tag2count.keySet()) {
                        if ((Integer)tag2count.get(tag) > maxCount) {
                            maxCount = (Integer)tag2count.get(tag);
                            maxima = 1;
                            classifiedAs = tag;
                            continue;
                        }
                        if ((Integer)tag2count.get(tag) != maxCount) continue;
                        ++maxima;
                    }
                    if (maxima > 1) {
                        double minWeight = Double.MAX_VALUE;
                        for (String tag : tag2count.keySet()) {
                            if (!((Double)tag2weight.get(tag) < minWeight)) continue;
                            minWeight = (Double)tag2weight.get(tag);
                            classifiedAs = tag;
                        }
                    }
                    ++count;
                    classesHTML.add(classifiedAs);
                    filesHTML.add(line);
                    if (classifiedAs.equals(HashingSearchBasedClassifierMod.getTagLine(line, photosLocation)) && classifiedAs.equals("yes")) {
                        ++countCorrect;
                        countTp += 1.0;
                    } else if (!classifiedAs.equals(HashingSearchBasedClassifierMod.getTagLine(line, photosLocation)) && classifiedAs.equals("yes")) {
                        countFp += 1.0;
                    }
                    if (classifiedAs.equals(HashingSearchBasedClassifierMod.getTagLine(line, photosLocation)) && classifiedAs.equals("no")) {
                        ++countCorrect;
                        countTn += 1.0;
                    } else if (!classifiedAs.equals(HashingSearchBasedClassifierMod.getTagLine(line, photosLocation)) && classifiedAs.equals("no")) {
                        countFn += 1.0;
                    }
                    int n = (Integer)class2id.get(classifiedAs);
                    confusion[n] = confusion[n] + 1;
                }
                catch (Exception e) {
                    System.err.println(">>> ERR:" + e.getMessage() + e);
                }
            }
            double precisicon = HashingSearchBasedClassifierMod.getPrecision(countTp, countFp);
            double recall = HashingSearchBasedClassifierMod.getRecall(countTp, countFn);
            double trueNegativeRate = HashingSearchBasedClassifierMod.getTrueNegativeRate(countTn, countFp);
            double accuracy = HashingSearchBasedClassifierMod.getAccuracy(countTp, countFp, countTn, countFn);
            double fMeasure = HashingSearchBasedClassifierMod.getFmeasure(precisicon, recall);
            double falsePositiveRate = HashingSearchBasedClassifierMod.getFalsePositiveRate(countFp, countTn);
            System.out.println(y + 1 + " of " + class1List.size() + " finished. " + (System.currentTimeMillis() - ms) / 1000L + " seconds per round. " + "Feature: " + (String)class1List.get(y) + " " + (String)class2List.get(y) + " " + (String)class3List.get(y) + " Current y: " + y);
            print_line.printf("%s;%s;%s;%s;%s;%s;%4.5f;%4.5f;%4.5f;%4.5f;%4.5f;%4.5f;%10d;%10d;%4d;%4.5f;%4.5f;%4.5f;%4.5f\n", class1List.get(y), class2List.get(y), class3List.get(y), k, weightByRank, classIdentifier, precisicon, recall, trueNegativeRate, accuracy, falsePositiveRate, fMeasure, count, countCorrect, (System.currentTimeMillis() - ms) / (long)count, countTp, countFp, countTn, countFn);
            print_line.flush();
            if (!createHTML) continue;
            String fileName = "classifieresults-" + System.currentTimeMillis() / 1000L + ".html";
            BufferedWriter bw = new BufferedWriter(new FileWriter(fileName));
            bw.write("<html>\n<head><title>Classification Results</title></head>\n<body bgcolor=\"#FFFFFF\">\n");
            bw.write("<table>");
            int elems = filesHTML.size();
            for (int i = 0; i < elems; ++i) {
                if (i % 3 == 0) {
                    bw.write("<tr>");
                }
                String s = (String)filesHTML.get(i);
                String colorF = "rgb(0, 255, 0)";
                if (((String)classesHTML.get(i)).equals("no")) {
                    colorF = "rgb(255, 0, 0)";
                }
                bw.write("<td><a href=\"" + s + "\"><img style=\"max-width:220px;border:medium solid " + colorF + ";\"src=\"" + s + "\" border=\"" + 5 + "\" style=\"border: 3px\n" + "black solid;\"></a></td>\n");
                if (i % 3 != 2) continue;
                bw.write("</tr>");
            }
            if (elems % 3 != 0) {
                if (elems % 3 == 2) {
                    bw.write("<td>-</td with exit code 0\nd>\n");
                    bw.write("<td>-</td>\n");
                } else if (elems % 3 == 2) {
                    bw.write("<td>-</td>\n");
                }
                bw.write("</tr>");
            }
            bw.write("</table></body>\n</html>");
            bw.close();
        }
        print_line.close();
        return true;
    }

    private static String getTag(Document d, String photosLocation) {
        StringBuilder ab = new StringBuilder(d.getValues("descriptorImageIdentifier")[0].replace(photosLocation, ""));
        return ab.substring(0, ab.indexOf("\\")).toString();
    }

    private static String getTagLine(String line, String photosLocation) {
        line = line.replace(photosLocation, "");
        return line.substring(0, line.indexOf("\\")).toString();
    }

    private static double getPrecision(double tp, double fp) {
        double precision = tp / (tp + fp);
        return precision;
    }

    private static double getRecall(double tp, double fn) {
        double recall = tp / (tp + fn);
        return recall;
    }

    private static double getTrueNegativeRate(double tn, double fp) {
        double negativeRate = tn / (tn + fp);
        return negativeRate;
    }

    private static double getAccuracy(double tp, double fp, double tn, double fn) {
        double accuracy = (tp + tn) / (tp + tn + fp + fn);
        return accuracy;
    }

    private static double getFalsePositiveRate(double fp, double tn) {
        double falsePositiveRate = fp / (fp + tn);
        return falsePositiveRate;
    }

    private static double getFmeasure(double precision, double recall) {
        double fMeasure = 2.0 * (precision * recall / (precision + recall));
        return fMeasure;
    }

    private static double getMccMeasure(double tp, double fp, double tn, double fn) {
        double mccMeasure = (tp * tn - fp * fn) / Math.sqrt((tp + fp) * (tp + fn) * (tn + fp) * (tn + fn));
        return mccMeasure;
    }

    private static double getWFM(double tp, double fp, double tn, double fn, double fMeasure, double allN) {
        double nPrec = tn / (tn + fn);
        double nRec = tn / (tn + fp);
        double nF1 = 2.0 * (nPrec * nRec) / (nPrec + nRec);
        double wFm = (fMeasure * (tp + fn) + nF1 * (fp + tn)) / allN;
        return wFm;
    }

    public static ArrayList print_nCr(int n, int r) {
        int[] res = new int[r];
        ArrayList<Integer> combinations = new ArrayList<Integer>();
        for (int i = 0; i < res.length; ++i) {
            res[i] = i + 1;
        }
        boolean done = false;
        while (!done) {
            for (int j = 0; j < res.length; ++j) {
                combinations.add(res[j]);
            }
            done = HashingSearchBasedClassifierMod.getNext(res, n, r);
        }
        return combinations;
    }

    public static boolean getNext(int[] num, int n, int r) {
        int target;
        int n2 = target = r - 1;
        num[n2] = num[n2] + 1;
        if (num[target] > n - (r - target) + 1) {
            while (num[target] > n - (r - target) && --target >= 0) {
            }
            if (target < 0) {
                return true;
            }
            int n3 = target;
            num[n3] = num[n3] + 1;
            for (int i = target + 1; i < num.length; ++i) {
                num[i] = num[i - 1] + 1;
            }
        }
        return false;
    }

    private static HashMap<String, Double> getFeaturesInformationGainScore(String photosLocation, String locationOfTrainSet, String locationExtracorFile, String[] classArray, int[] featureSpace, double[] featureInformationGain, HashMap<String, Integer> featureSpaceHashMap, HashMap<String, Double> featureInformationGainHashMap) throws IOException, ClassNotFoundException, IllegalAccessException, InstantiationException {
        int tmp;
        String storeToFile = System.currentTimeMillis() + "wekaTemp.arff";
        PrintWriter print_line = new PrintWriter(new BufferedWriter(new FileWriter(storeToFile)));
        print_line.print("@relation vowel-train\n\n");
        print_line.flush();
        FileInputStream inf = new FileInputStream(locationExtracorFile);
        byte[] tempIntf = new byte[4];
        ArrayList<String> featureOrder = new ArrayList<String>();
        byte[] tempf = new byte[102400];
        int tmpf = ((InputStream)inf).read(tempIntf, 0, 4);
        if (tmpf > 0) {
            tmpf = SerializationUtils.toInt(tempIntf);
            ((InputStream)inf).read(tempf, 0, tmpf);
            while (((InputStream)inf).read(tempIntf, 0, 1) > 0 && tempIntf[0] != -1) {
                byte tmpFeaturef = tempIntf[0];
                LireFeature f = (LireFeature)Class.forName(Extractor.features[tmpFeaturef]).newInstance();
                ((InputStream)inf).read(tempIntf, 0, 4);
                tmpf = SerializationUtils.toInt(tempIntf);
                ((InputStream)inf).read(tempf, 0, tmpf);
                f.setByteArrayRepresentation(tempf, 0, tmpf);
                featureOrder.add(f.getClass().getSimpleName());
            }
        }
        for (int i = 0; i < featureOrder.size(); ++i) {
            for (int j = 0; j < featureSpaceHashMap.get(featureOrder.get(i)); ++j) {
                print_line.print("@attribute " + i + "_" + (String)featureOrder.get(i) + "_" + j + " " + "numeric" + "\n" + "\n");
            }
            print_line.flush();
        }
        print_line.print("@attribute Class {yes,no}\n\n@data\n\n");
        print_line.flush();
        BufferedReader br = new BufferedReader(new FileReader(locationOfTrainSet));
        FileInputStream in = new FileInputStream(locationExtracorFile);
        byte[] tempInt = new byte[4];
        byte[] temp = new byte[102400];
        while ((tmp = ((InputStream)in).read(tempInt, 0, 4)) > 0) {
            tmp = SerializationUtils.toInt(tempInt);
            ((InputStream)in).read(temp, 0, tmp);
            String filename = new String(temp, 0, tmp);
            String tag = HashingSearchBasedClassifierMod.getTagLine(filename, photosLocation);
            while (((InputStream)in).read(tempInt, 0, 1) > 0 && tempInt[0] != -1) {
                byte tmpFeature = tempInt[0];
                LireFeature f = (LireFeature)Class.forName(Extractor.features[tmpFeature]).newInstance();
                ((InputStream)in).read(tempInt, 0, 4);
                tmp = SerializationUtils.toInt(tempInt);
                ((InputStream)in).read(temp, 0, tmp);
                f.setByteArrayRepresentation(temp, 0, tmp);
                double[] tempDouble = f.getDoubleHistogram();
                double tempMean = 0.0;
                for (int j = 0; j < tempDouble.length; ++j) {
                    print_line.print(tempDouble[j] + ",");
                }
            }
            print_line.print(tag + ",");
            print_line.print("\n");
            print_line.flush();
        }
        print_line.close();
        return HashingSearchBasedClassifierMod.calculateInformationGain(storeToFile, featureInformationGain, featureSpace, featureSpaceHashMap, featureOrder, featureInformationGainHashMap);
    }

    private static HashMap<String, Double> calculateInformationGain(String wekaFileLocation, double[] featureInformationGain, int[] featureSpace, HashMap<String, Integer> featureSpaceHashMap, ArrayList<String> featureOrder, HashMap<String, Double> featureInformationGainHashMap) {
        int i;
        Instances data = null;
        try {
            data = new Instances((Reader)new BufferedReader(new FileReader(wekaFileLocation)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        AttributeSelection attsel = new AttributeSelection();
        InfoGainAttributeEval eval = new InfoGainAttributeEval();
        Ranker search = new Ranker();
        search.setThreshold(-1.7976931348623157E308);
        search.setNumToSelect(-1);
        search.setGenerateRanking(true);
        attsel.setEvaluator((ASEvaluation)eval);
        attsel.setSearch((ASSearch)search);
        try {
            attsel.SelectAttributes(data);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        int[] indices = new int[]{};
        double[][] rankedAttribuesArray = new double[0][0];
        try {
            rankedAttribuesArray = attsel.rankedAttributes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            indices = attsel.selectedAttributes();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        for (i = 0; i < rankedAttribuesArray.length; ++i) {
            int currentFeature = Integer.parseInt(data.attribute((int)rankedAttribuesArray[i][0]).name().substring(0, data.attribute((int)rankedAttribuesArray[i][0]).name().indexOf("_")));
            featureInformationGainHashMap.put(featureOrder.get(currentFeature), featureInformationGainHashMap.get(featureOrder.get(currentFeature)) + rankedAttribuesArray[i][1]);
        }
        for (i = 0; i < featureOrder.size(); ++i) {
            featureInformationGainHashMap.put(featureOrder.get(i), featureInformationGainHashMap.get(featureOrder.get(i)));
        }
        System.out.println("Scoring finished, starting with classification! Scores: ");
        for (i = 0; i < featureOrder.size(); ++i) {
            System.out.println(featureOrder.get(i) + " " + featureInformationGainHashMap.get(featureOrder.get(i)));
        }
        File deleteFile = new File(wekaFileLocation);
        deleteFile.delete();
        return featureInformationGainHashMap;
    }

    public void testThreadClassifyThreeFeatures() throws IOException {
        Thread[] all = new Thread[]{new Thread(new Classifie3Task(0, 56, "D:\\resultsTripleFeatureItemK31.txt")), new Thread(new Classifie3Task(56, 111, "D:\\resultsTripleFeatureItemK32.txt")), new Thread(new Classifie3Task(111, 166, "D:\\resultsTripleFeatureItemK33.txt")), new Thread(new Classifie3Task(166, 220, "D:\\resultsTripleFeatureItemK34.txt"))};
        all[0].start();
        all[1].start();
        all[2].start();
        all[3].start();
        try {
            all[0].join();
            all[1].join();
            all[2].join();
            all[3].join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static class Classifie3Task
    implements Runnable {
        int start;
        int end;
        String storeToFile;

        public Classifie3Task(int start, int end, String storeToFile) {
            this.start = start;
            this.end = end;
            this.storeToFile = storeToFile;
        }

        @Override
        public void run() {
            try {
                HashingSearchBasedClassifierMod.testClassifyFashionThreeCombinedFeaturesMulti(this.start, this.end, this.storeToFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

