/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.StringTokenizer;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.imageanalysis.cedd.CEDDQuant;
import net.semanticmetadata.lire.imageanalysis.cedd.CompactCEDDQuant;
import net.semanticmetadata.lire.imageanalysis.cedd.Fuzzy10Bin;
import net.semanticmetadata.lire.imageanalysis.cedd.Fuzzy24Bin;
import net.semanticmetadata.lire.imageanalysis.cedd.MaskResults;
import net.semanticmetadata.lire.imageanalysis.cedd.Neighborhood;
import net.semanticmetadata.lire.imageanalysis.cedd.RGB2HSV;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class CEDD
implements LireFeature {
    private double T0;
    private double T1;
    private double T2;
    private double T3;
    private boolean Compact = false;
    protected byte[] histogram = new byte[144];
    int tmp;
    private double Result;
    private double Temp1;
    private double Temp2;
    private double TempCount1;
    private double TempCount2;
    private double TempCount3;
    private CEDD tmpFeature;
    private double iTmp1;
    private double iTmp2;

    public CEDD(double Th0, double Th1, double Th2, double Th3, boolean CompactDescriptor) {
        this.T0 = Th0;
        this.T1 = Th1;
        this.T2 = Th2;
        this.T3 = Th3;
        this.Compact = CompactDescriptor;
    }

    public CEDD() {
        this.T0 = 14.0;
        this.T1 = 0.68;
        this.T2 = 0.98;
        this.T3 = 0.98;
    }

    @Override
    public void extract(BufferedImage image) {
        Object quants;
        double[] qCEDD;
        int i;
        image = ImageUtils.get8BitRGBImage(image);
        Fuzzy10Bin Fuzzy10 = new Fuzzy10Bin(false);
        Fuzzy24Bin Fuzzy24 = new Fuzzy24Bin(false);
        RGB2HSV HSVConverter = new RGB2HSV();
        int[] HSV = new int[3];
        double[] Fuzzy10BinResultTable = new double[10];
        double[] Fuzzy24BinResultTable = new double[24];
        double[] CEDD2 = new double[144];
        int width = image.getWidth();
        int height = image.getHeight();
        double[][] ImageGrid = new double[width][height];
        double[][] PixelCount = new double[2][2];
        int[][] ImageGridRed = new int[width][height];
        int[][] ImageGridGreen = new int[width][height];
        int[][] ImageGridBlue = new int[width][height];
        int NumberOfBlocks = 1600;
        int Step_X = (int)Math.floor((double)width / Math.sqrt(NumberOfBlocks));
        int Step_Y = (int)Math.floor((double)height / Math.sqrt(NumberOfBlocks));
        if (Step_X % 2 != 0) {
            --Step_X;
        }
        if (Step_Y % 2 != 0) {
            --Step_Y;
        }
        if (Step_Y < 2) {
            Step_Y = 2;
        }
        if (Step_X < 2) {
            Step_X = 2;
        }
        int[] Edges = new int[6];
        MaskResults MaskValues = new MaskResults();
        Neighborhood PixelsNeighborhood = new Neighborhood();
        for (int i2 = 0; i2 < 144; ++i2) {
            CEDD2[i2] = 0.0;
        }
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                int pixel = image.getRGB(x, y);
                ImageGridRed[x][y] = pixel >> 16 & 0xFF;
                ImageGridGreen[x][y] = pixel >> 8 & 0xFF;
                ImageGridBlue[x][y] = pixel & 0xFF;
                int mean = (int)(0.114 * (double)ImageGridBlue[x][y] + 0.587 * (double)ImageGridGreen[x][y] + 0.299 * (double)ImageGridRed[x][y]);
                ImageGrid[x][y] = mean;
            }
        }
        int[] CororRed = new int[Step_Y * Step_X];
        int[] CororGreen = new int[Step_Y * Step_X];
        int[] CororBlue = new int[Step_Y * Step_X];
        int[] CororRedTemp = new int[Step_Y * Step_X];
        int[] CororGreenTemp = new int[Step_Y * Step_X];
        int[] CororBlueTemp = new int[Step_Y * Step_X];
        for (int y = 0; y < height - Step_Y; y += Step_Y) {
            for (int x = 0; x < width - Step_X; x += Step_X) {
                int j;
                int i3;
                int MeanRed = 0;
                int MeanGreen = 0;
                int MeanBlue = 0;
                PixelsNeighborhood.Area1 = 0.0;
                PixelsNeighborhood.Area2 = 0.0;
                PixelsNeighborhood.Area3 = 0.0;
                PixelsNeighborhood.Area4 = 0.0;
                Edges[0] = -1;
                Edges[1] = -1;
                Edges[2] = -1;
                Edges[3] = -1;
                Edges[4] = -1;
                Edges[5] = -1;
                for (i = 0; i < 2; ++i) {
                    for (int j2 = 0; j2 < 2; ++j2) {
                        PixelCount[i][j2] = 0.0;
                    }
                }
                int TempSum = 0;
                for (int i4 = y; i4 < y + Step_Y; ++i4) {
                    for (int j3 = x; j3 < x + Step_X; ++j3) {
                        CororRed[TempSum] = ImageGridRed[j3][i4];
                        CororGreen[TempSum] = ImageGridGreen[j3][i4];
                        CororBlue[TempSum] = ImageGridBlue[j3][i4];
                        CororRedTemp[TempSum] = ImageGridRed[j3][i4];
                        CororGreenTemp[TempSum] = ImageGridGreen[j3][i4];
                        CororBlueTemp[TempSum] = ImageGridBlue[j3][i4];
                        ++TempSum;
                        if (j3 < x + Step_X / 2 && i4 < y + Step_Y / 2) {
                            PixelsNeighborhood.Area1 += 4.0 * ImageGrid[j3][i4] / (double)(Step_X * Step_Y);
                        }
                        if (j3 >= x + Step_X / 2 && i4 < y + Step_Y / 2) {
                            PixelsNeighborhood.Area2 += 4.0 * ImageGrid[j3][i4] / (double)(Step_X * Step_Y);
                        }
                        if (j3 < x + Step_X / 2 && i4 >= y + Step_Y / 2) {
                            PixelsNeighborhood.Area3 += 4.0 * ImageGrid[j3][i4] / (double)(Step_X * Step_Y);
                        }
                        if (j3 < x + Step_X / 2 || i4 < y + Step_Y / 2) continue;
                        PixelsNeighborhood.Area4 += 4.0 * ImageGrid[j3][i4] / (double)(Step_X * Step_Y);
                    }
                }
                MaskValues.Mask1 = Math.abs(PixelsNeighborhood.Area1 * 2.0 + PixelsNeighborhood.Area2 * -2.0 + PixelsNeighborhood.Area3 * -2.0 + PixelsNeighborhood.Area4 * 2.0);
                MaskValues.Mask2 = Math.abs(PixelsNeighborhood.Area1 * 1.0 + PixelsNeighborhood.Area2 * 1.0 + PixelsNeighborhood.Area3 * -1.0 + PixelsNeighborhood.Area4 * -1.0);
                MaskValues.Mask3 = Math.abs(PixelsNeighborhood.Area1 * 1.0 + PixelsNeighborhood.Area2 * -1.0 + PixelsNeighborhood.Area3 * 1.0 + PixelsNeighborhood.Area4 * -1.0);
                MaskValues.Mask4 = Math.abs(PixelsNeighborhood.Area1 * Math.sqrt(2.0) + PixelsNeighborhood.Area2 * 0.0 + PixelsNeighborhood.Area3 * 0.0 + PixelsNeighborhood.Area4 * -Math.sqrt(2.0));
                MaskValues.Mask5 = Math.abs(PixelsNeighborhood.Area1 * 0.0 + PixelsNeighborhood.Area2 * Math.sqrt(2.0) + PixelsNeighborhood.Area3 * -Math.sqrt(2.0) + PixelsNeighborhood.Area4 * 0.0);
                double Max = Math.max(MaskValues.Mask1, Math.max(MaskValues.Mask2, Math.max(MaskValues.Mask3, Math.max(MaskValues.Mask4, MaskValues.Mask5))));
                MaskValues.Mask1 /= Max;
                MaskValues.Mask2 /= Max;
                MaskValues.Mask3 /= Max;
                MaskValues.Mask4 /= Max;
                MaskValues.Mask5 /= Max;
                int T = -1;
                if (Max < this.T0) {
                    Edges[0] = 0;
                    T = 0;
                } else {
                    T = -1;
                    if (MaskValues.Mask1 > this.T1) {
                        Edges[++T] = 1;
                    }
                    if (MaskValues.Mask2 > this.T2) {
                        Edges[++T] = 2;
                    }
                    if (MaskValues.Mask3 > this.T2) {
                        Edges[++T] = 3;
                    }
                    if (MaskValues.Mask4 > this.T3) {
                        Edges[++T] = 4;
                    }
                    if (MaskValues.Mask5 > this.T3) {
                        Edges[++T] = 5;
                    }
                }
                for (i3 = 0; i3 < Step_Y * Step_X; ++i3) {
                    MeanRed += CororRed[i3];
                    MeanGreen += CororGreen[i3];
                    MeanBlue += CororBlue[i3];
                }
                HSV = HSVConverter.ApplyFilter(MeanRed /= Step_Y * Step_X, MeanGreen /= Step_Y * Step_X, MeanBlue /= Step_Y * Step_X);
                if (!this.Compact) {
                    Fuzzy10BinResultTable = Fuzzy10.ApplyFilter(HSV[0], HSV[1], HSV[2], 2);
                    Fuzzy24BinResultTable = Fuzzy24.ApplyFilter(HSV[0], HSV[1], HSV[2], Fuzzy10BinResultTable, 2);
                    for (i3 = 0; i3 <= T; ++i3) {
                        for (j = 0; j < 24; ++j) {
                            if (!(Fuzzy24BinResultTable[j] > 0.0)) continue;
                            int n = 24 * Edges[i3] + j;
                            CEDD2[n] = CEDD2[n] + Fuzzy24BinResultTable[j];
                        }
                    }
                    continue;
                }
                Fuzzy10BinResultTable = Fuzzy10.ApplyFilter(HSV[0], HSV[1], HSV[2], 2);
                for (i3 = 0; i3 <= T; ++i3) {
                    for (j = 0; j < 10; ++j) {
                        if (!(Fuzzy10BinResultTable[j] > 0.0)) continue;
                        int n = 10 * Edges[i3] + j;
                        CEDD2[n] = CEDD2[n] + Fuzzy10BinResultTable[j];
                    }
                }
            }
        }
        double Sum = 0.0;
        for (i = 0; i < 144; ++i) {
            Sum += CEDD2[i];
        }
        for (i = 0; i < 144; ++i) {
            CEDD2[i] = CEDD2[i] / Sum;
        }
        if (!this.Compact) {
            qCEDD = new double[144];
            quants = new CEDDQuant();
            qCEDD = ((CEDDQuant)quants).Apply(CEDD2);
        } else {
            qCEDD = new double[60];
            quants = new CompactCEDDQuant();
            qCEDD = ((CompactCEDDQuant)quants).Apply(CEDD2);
        }
        for (int i5 = 0; i5 < qCEDD.length; ++i5) {
            this.histogram[i5] = (byte)qCEDD[i5];
        }
    }

    @Override
    public float getDistance(LireFeature vd) {
        int i;
        if (!(vd instanceof CEDD)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        this.tmpFeature = (CEDD)vd;
        if (this.tmpFeature.histogram.length != this.histogram.length) {
            throw new UnsupportedOperationException("Histogram lengths or color spaces do not match");
        }
        this.Result = 0.0;
        this.Temp1 = 0.0;
        this.Temp2 = 0.0;
        this.TempCount1 = 0.0;
        this.TempCount2 = 0.0;
        this.TempCount3 = 0.0;
        for (i = 0; i < this.tmpFeature.histogram.length; ++i) {
            this.Temp1 += (double)this.tmpFeature.histogram[i];
            this.Temp2 += (double)this.histogram[i];
        }
        if (this.Temp1 == 0.0 && this.Temp2 == 0.0) {
            return 0.0f;
        }
        if (this.Temp1 == 0.0 || this.Temp2 == 0.0) {
            return 100.0f;
        }
        for (i = 0; i < this.tmpFeature.histogram.length; ++i) {
            this.iTmp1 = (double)this.tmpFeature.histogram[i] / this.Temp1;
            this.iTmp2 = (double)this.histogram[i] / this.Temp2;
            this.TempCount1 += this.iTmp1 * this.iTmp2;
            this.TempCount2 += this.iTmp2 * this.iTmp2;
            this.TempCount3 += this.iTmp1 * this.iTmp1;
        }
        this.Result = 100.0 - 100.0 * (this.TempCount1 / (this.TempCount2 + this.TempCount3 - this.TempCount1));
        return (float)this.Result;
    }

    private double scalarMult(double[] a, double[] b) {
        double sum = 0.0;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] * b[i];
        }
        return sum;
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder(this.histogram.length * 2 + 25);
        sb.append("cedd");
        sb.append(' ');
        sb.append(this.histogram.length);
        sb.append(' ');
        for (byte aData : this.histogram) {
            sb.append(aData);
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    @Override
    public void setStringRepresentation(String s) {
        StringTokenizer st = new StringTokenizer(s);
        if (!st.nextToken().equals("cedd")) {
            throw new UnsupportedOperationException("This is not a CEDD descriptor.");
        }
        for (int i = 0; i < this.histogram.length; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IndexOutOfBoundsException("Too few numbers in string representation.");
            }
            this.histogram[i] = (byte)Integer.parseInt(st.nextToken());
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        int position = -1;
        for (int i = 0; i < this.histogram.length; ++i) {
            if (position == -1) {
                if (this.histogram[i] != 0) continue;
                position = i;
                continue;
            }
            if (position <= -1 || this.histogram[i] == 0) continue;
            position = -1;
        }
        if (position < 0) {
            position = 143;
        }
        int length = (position + 1) / 2;
        if ((position + 1) % 2 == 1) {
            length = position / 2 + 1;
        }
        byte[] result = new byte[length];
        for (int i = 0; i < result.length; ++i) {
            this.tmp = this.histogram[i << 1] << 4;
            this.tmp |= this.histogram[(i << 1) + 1];
            result[i] = (byte)(this.tmp - 128);
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        if (in.length << 1 < this.histogram.length) {
            Arrays.fill(this.histogram, in.length << 1, this.histogram.length - 1, (byte)0);
        }
        for (int i = 0; i < in.length; ++i) {
            this.tmp = in[i] + 128;
            this.histogram[(i << 1) + 1] = (byte)(this.tmp & 0xF);
            this.histogram[i << 1] = (byte)(this.tmp >> 4);
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        if (length << 1 < this.histogram.length) {
            Arrays.fill(this.histogram, length << 1, this.histogram.length - 1, (byte)0);
        }
        for (int i = offset; i < offset + length; ++i) {
            this.tmp = in[i] + 128;
            this.histogram[(i - offset << 1) + 1] = (byte)(this.tmp & 0xF);
            this.histogram[i - offset << 1] = (byte)(this.tmp >> 4);
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return SerializationUtils.castToDoubleArray(this.histogram);
    }

    @Override
    public String getFeatureName() {
        return "CEDD";
    }

    @Override
    public String getFieldName() {
        return "featureCEDD";
    }
}

