/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.imageanalysis.mpeg7.EdgeHistogramImplementation;
import net.semanticmetadata.lire.utils.ConversionUtils;

public class EdgeHistogram
extends EdgeHistogramImplementation
implements LireFeature {
    private int tmp;

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.edgeHistogram.length / 2];
        for (int i = 0; i < result.length; ++i) {
            this.tmp = this.edgeHistogram[i << 1] << 4;
            this.tmp |= this.edgeHistogram[(i << 1) + 1];
            result[i] = (byte)(this.tmp - 128);
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.tmp = in[offset + i] + 128;
            this.edgeHistogram[(i << 1) + 1] = this.tmp & 0xF;
            this.edgeHistogram[i << 1] = this.tmp >> 4;
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return ConversionUtils.toDouble(this.edgeHistogram);
    }

    @Override
    public String getFeatureName() {
        return "MPEG-7 Edge Histogram";
    }

    @Override
    public String getFieldName() {
        return "descriptorEdgeHistogram";
    }
}

