/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.StringTokenizer;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.SerializationUtils;

public class FuzzyColorHistogram
implements LireFeature {
    protected Color[] binColors;
    protected final int SIZE = 5;
    protected final int SIZE3 = 125;
    protected int[] descriptorValues;

    @Override
    public void extract(BufferedImage bimg) {
        int k;
        this.binColors = new Color[125];
        int counter = 0;
        for (int k2 = 0; k2 < 5; ++k2) {
            for (int j = 0; j < 5; ++j) {
                for (int i = 0; i < 5; ++i) {
                    this.binColors[counter] = this.getColorForBin(i, j, k2);
                    ++counter;
                }
            }
        }
        double[] histogramA = new double[125];
        int width = bimg.getWidth();
        int height = bimg.getHeight();
        WritableRaster raster = bimg.getRaster();
        int[] pixel = new int[3];
        for (int j = 0; j < height; ++j) {
            for (int i = 0; i < width; ++i) {
                raster.getPixel(i, j, pixel);
                int r = pixel[0];
                int g = pixel[1];
                int b = pixel[2];
                int k3 = 0;
                while (k3 < 125) {
                    double rDiff = (double)this.binColors[k3].getRed() - (double)r;
                    double gDiff = (double)this.binColors[k3].getGreen() - (double)g;
                    double bDiff = (double)this.binColors[k3].getBlue() - (double)b;
                    double rdist = rDiff * rDiff + gDiff * gDiff + bDiff * bDiff;
                    int n = k3++;
                    histogramA[n] = histogramA[n] + 10.0 / Math.sqrt(rdist + 1.0);
                }
            }
        }
        double maxA = 0.0;
        for (k = 0; k < 125; ++k) {
            if (!(histogramA[k] > maxA)) continue;
            maxA = histogramA[k];
        }
        this.descriptorValues = new int[125];
        for (k = 0; k < 125; ++k) {
            this.descriptorValues[k] = (int)(histogramA[k] / maxA * 255.0);
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        return SerializationUtils.toByteArray(this.descriptorValues);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.descriptorValues = SerializationUtils.toIntArray(in);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.descriptorValues = SerializationUtils.toIntArray(in, offset, length);
    }

    @Override
    public double[] getDoubleHistogram() {
        return SerializationUtils.toDoubleArray(this.descriptorValues);
    }

    @Override
    public float getDistance(LireFeature vd) {
        if (!(vd instanceof FuzzyColorHistogram)) {
            throw new UnsupportedOperationException("Wrong descriptor.");
        }
        FuzzyColorHistogram target = (FuzzyColorHistogram)vd;
        double distance = 0.0;
        for (int i = 0; i < 125; ++i) {
            distance += (double)((this.descriptorValues[i] - target.descriptorValues[i]) * (this.descriptorValues[i] - target.descriptorValues[i]));
        }
        return (float)Math.sqrt(distance / 125.0);
    }

    @Override
    public String getStringRepresentation() {
        StringBuilder sb = new StringBuilder(this.descriptorValues.length * 2 + 25);
        sb.append("fuzzycolorhist");
        sb.append(' ');
        sb.append(this.descriptorValues.length);
        sb.append(' ');
        int[] arr$ = this.descriptorValues;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            double aData = arr$[i$];
            sb.append((int)aData);
            sb.append(' ');
        }
        return sb.toString().trim();
    }

    @Override
    public void setStringRepresentation(String s) {
        StringTokenizer st = new StringTokenizer(s);
        if (!st.nextToken().equals("fuzzycolorhist")) {
            throw new UnsupportedOperationException("This is not a fuzzycolorhist descriptor.");
        }
        this.descriptorValues = new int[Integer.parseInt(st.nextToken())];
        for (int i = 0; i < this.descriptorValues.length; ++i) {
            if (!st.hasMoreTokens()) {
                throw new IndexOutOfBoundsException("Too few numbers in string representation.");
            }
            this.descriptorValues[i] = Integer.parseInt(st.nextToken());
        }
    }

    protected Color getColorForBin(int rBin, int gBin, int bBin) {
        int binWidth = 51;
        int offset = binWidth / 2;
        return new Color(rBin * binWidth + offset, gBin * binWidth + offset, bBin * binWidth + offset);
    }

    @Override
    public String getFeatureName() {
        return "Fuzzy Color Histogram";
    }

    @Override
    public String getFieldName() {
        return "f_fuzcolhis";
    }
}

