/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class LuminanceLayout
implements LireFeature {
    double[] histogram;
    int tmp;
    static ColorConvertOp grayscale = new ColorConvertOp(ColorSpace.getInstance(1003), new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR));
    private int sideLength = 8;

    @Override
    public void extract(BufferedImage bimg) {
        BufferedImage gray = grayscale.filter(bimg, null);
        BufferedImage small = new BufferedImage(this.sideLength, this.sideLength, 10);
        double scale = (double)Math.max(gray.getWidth(), gray.getHeight()) / 32.0;
        int w = (int)((double)gray.getWidth() / scale);
        int h = (int)((double)gray.getHeight() / scale);
        int x = 0;
        int y = 0;
        if (w < this.sideLength) {
            x = (this.sideLength - w) / 2;
        }
        if (h < this.sideLength) {
            y = (this.sideLength - h) / 2;
        }
        small.getGraphics().fillRect(0, 0, this.sideLength, this.sideLength);
        small.getGraphics().drawImage(gray, x, y, w, h, null);
        this.histogram = new double[this.sideLength * this.sideLength];
        small.getRaster().getPixels(0, 0, this.sideLength, this.sideLength, this.histogram);
        for (int i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = Math.floor(this.histogram[i] / 8.0);
        }
    }

    private void enhanceContrast(BufferedImage gray) {
        int[] tmp = new int[]{0};
        int min = 255;
        int max = 0;
        for (int x = 0; x < gray.getWidth(); ++x) {
            for (int y = 0; y < gray.getHeight(); ++y) {
                gray.getRaster().getPixel(x, y, tmp);
                min = Math.min(tmp[0], min);
                max = Math.max(tmp[0], max);
            }
        }
        if (max < 255 || min > 0) {
            double scale = ((double)max - (double)min) / 255.0;
            for (int x = 0; x < gray.getWidth(); ++x) {
                for (int y = 0; y < gray.getHeight(); ++y) {
                    gray.getRaster().getPixel(x, y, tmp);
                    double val = Math.floor((double)(tmp[0] - min) / scale);
                    tmp[0] = (int)val;
                    gray.getRaster().setPixel(x, y, tmp);
                }
            }
        }
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] result = new byte[this.histogram.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (byte)this.histogram[i];
        }
        return result;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.histogram = new double[in.length];
        for (int i = 0; i < in.length; ++i) {
            this.histogram[i] = in[i];
        }
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        this.histogram = new double[length];
        for (int i = 0; i < length; ++i) {
            this.histogram[i] = in[i + offset];
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return this.histogram;
    }

    @Override
    public float getDistance(LireFeature feature) {
        return (float)MetricsUtils.distL1(this.histogram, ((LuminanceLayout)feature).histogram);
    }

    @Override
    public String getStringRepresentation() {
        return null;
    }

    @Override
    public void setStringRepresentation(String s) {
    }

    private double[] jpgDct(double[] histogram) {
        int[] zickzack = new int[]{0, 1, 8, 16, 9, 2, 3, 10, 17, 24, 32, 25, 18, 11, 4, 5, 12, 19, 26, 33, 40, 48, 41, 34, 27, 20, 13, 6, 7, 14, 21, 28, 35, 42, 49, 56};
        double[] quant = new double[]{16.0, 5.0, 6.0, 7.0, 6.0, 5.0, 8.0, 7.0, 7.0, 7.0, 9.0, 8.0, 8.0, 9.0, 12.0, 20.0, 13.0, 12.0, 11.0, 11.0, 12.0, 25.0, 18.0, 18.0, 15.0, 20.0, 28.0, 25.0, 30.0, 30.0, 28.0, 25.0, 28.0, 27.0, 32.0, 36.0};
        double[] coeffs = new double[histogram.length];
        for (int i = 0; i < coeffs.length; ++i) {
            int u = i % 8;
            int v = i / 8;
            double au = Math.sqrt(0.3333333333333333);
            double av = Math.sqrt(0.3333333333333333);
            if (u == 0) {
                au = Math.sqrt(0.16666666666666666);
            }
            if (v == 0) {
                av = Math.sqrt(0.16666666666666666);
            }
            coeffs[i] = 0.0;
            for (int x = 0; x < 8; ++x) {
                for (int y = 0; y < 8; ++y) {
                    int n = i;
                    coeffs[n] = coeffs[n] + au * av * (histogram[i] - 127.0) * Math.cos(0.39269908169872414 * ((double)x + 0.5) * (double)u) * Math.cos(0.39269908169872414 * ((double)y + 0.5) * (double)v);
                }
            }
        }
        double[] result = new double[zickzack.length];
        for (int i = 0; i < zickzack.length; ++i) {
            result[i] = Math.round(coeffs[zickzack[i]]);
        }
        return result;
    }

    private double[] dct(double[] histogram) {
        double[] coeffs = new double[histogram.length / 8];
        double N = histogram.length;
        double min = 0.0;
        double max = 0.0;
        for (int i = 0; i < coeffs.length; ++i) {
            coeffs[i] = 0.0;
            int j = 0;
            while ((double)j < N) {
                int n = i;
                coeffs[n] = coeffs[n] + histogram[j] * Math.cos(Math.PI / N * ((double)j + 0.5) * ((double)i + 0.5));
                ++j;
            }
            min = Math.min(min, coeffs[i]);
            max = Math.max(max, coeffs[i]);
        }
        double factor = Math.max(max, Math.abs(min));
        for (int i = 0; i < coeffs.length; ++i) {
            coeffs[i] = Math.floor(coeffs[i] / factor * 63.0 + 63.0);
        }
        return coeffs;
    }

    @Override
    public String getFeatureName() {
        return "Luminance Layout";
    }

    @Override
    public String getFieldName() {
        return "featLumLay";
    }
}

