/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis;

import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;
import net.semanticmetadata.lire.utils.MetricsUtils;

public class RotationInvariantLocalBinaryPatterns
implements LireFeature {
    double[] histogram = new double[36];
    static int[] binTranslate = new int[256];

    @Override
    public void extract(BufferedImage image) {
        Arrays.fill(this.histogram, 0.0);
        this.extractWithRadiusOne(image);
    }

    private void extractWithRadiusOne(BufferedImage image) {
        int i;
        WritableRaster raster = ImageUtils.getGrayscaleImage(image).getRaster();
        int[] pixel = new int[9];
        int[] pattern = new int[8];
        for (int x = 0; x < raster.getWidth() - 2; ++x) {
            for (int y = 0; y < raster.getHeight() - 2; ++y) {
                Arrays.fill(pattern, 0);
                raster.getPixels(x, y, 3, 3, pixel);
                if (pixel[0] >= pixel[4]) {
                    pattern[0] = 1;
                }
                if (pixel[1] >= pixel[4]) {
                    pattern[1] = 1;
                }
                if (pixel[2] >= pixel[4]) {
                    pattern[2] = 1;
                }
                if (pixel[5] >= pixel[4]) {
                    pattern[3] = 1;
                }
                if (pixel[8] >= pixel[4]) {
                    pattern[4] = 1;
                }
                if (pixel[7] >= pixel[4]) {
                    pattern[5] = 1;
                }
                if (pixel[6] >= pixel[4]) {
                    pattern[6] = 1;
                }
                if (pixel[3] >= pixel[4]) {
                    pattern[7] = 1;
                }
                int n = this.getBin(pattern);
                this.histogram[n] = this.histogram[n] + 1.0;
            }
        }
        double max = 0.0;
        for (i = 0; i < this.histogram.length; ++i) {
            max = Math.max(this.histogram[i], max);
        }
        for (i = 0; i < this.histogram.length; ++i) {
            this.histogram[i] = Math.floor(this.histogram[i] / max * 127.0);
        }
    }

    private int getBin(int[] pattern) {
        int min = Integer.MAX_VALUE;
        for (int i = 0; i < 8; ++i) {
            min = Math.min(this.getNumber(pattern), min);
            int tmp = pattern[7];
            for (int j = pattern.length - 1; j > 0; --j) {
                pattern[j] = pattern[j - 1];
            }
            pattern[0] = tmp;
        }
        return binTranslate[min];
    }

    private int getNumber(int[] pattern) {
        int result = 0;
        int current = 1;
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] > 0) {
                result += current;
            }
            current *= 2;
        }
        return result;
    }

    @Override
    public byte[] getByteArrayRepresentation() {
        byte[] rep = new byte[this.histogram.length];
        for (int i = 0; i < this.histogram.length; ++i) {
            rep[i] = (byte)this.histogram[i];
        }
        return rep;
    }

    @Override
    public void setByteArrayRepresentation(byte[] in) {
        this.setByteArrayRepresentation(in, 0, in.length);
    }

    @Override
    public void setByteArrayRepresentation(byte[] in, int offset, int length) {
        for (int i = offset; i < offset + length; ++i) {
            this.histogram[i - offset] = in[i];
        }
    }

    @Override
    public double[] getDoubleHistogram() {
        return this.histogram;
    }

    @Override
    public float getDistance(LireFeature feature) {
        return (float)MetricsUtils.distL1(this.histogram, feature.getDoubleHistogram());
    }

    @Override
    public String getStringRepresentation() {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public void setStringRepresentation(String s) {
        throw new UnsupportedOperationException("Not implemented!");
    }

    @Override
    public String getFeatureName() {
        return "Rotation Invariant LBP";
    }

    @Override
    public String getFieldName() {
        return "featRILBP";
    }

    static {
        Arrays.fill(binTranslate, 0);
        RotationInvariantLocalBinaryPatterns.binTranslate[0] = 0;
        RotationInvariantLocalBinaryPatterns.binTranslate[1] = 1;
        RotationInvariantLocalBinaryPatterns.binTranslate[3] = 2;
        RotationInvariantLocalBinaryPatterns.binTranslate[5] = 3;
        RotationInvariantLocalBinaryPatterns.binTranslate[7] = 4;
        RotationInvariantLocalBinaryPatterns.binTranslate[9] = 5;
        RotationInvariantLocalBinaryPatterns.binTranslate[11] = 6;
        RotationInvariantLocalBinaryPatterns.binTranslate[13] = 7;
        RotationInvariantLocalBinaryPatterns.binTranslate[15] = 8;
        RotationInvariantLocalBinaryPatterns.binTranslate[17] = 9;
        RotationInvariantLocalBinaryPatterns.binTranslate[19] = 10;
        RotationInvariantLocalBinaryPatterns.binTranslate[21] = 11;
        RotationInvariantLocalBinaryPatterns.binTranslate[23] = 12;
        RotationInvariantLocalBinaryPatterns.binTranslate[25] = 13;
        RotationInvariantLocalBinaryPatterns.binTranslate[27] = 14;
        RotationInvariantLocalBinaryPatterns.binTranslate[29] = 15;
        RotationInvariantLocalBinaryPatterns.binTranslate[31] = 16;
        RotationInvariantLocalBinaryPatterns.binTranslate[37] = 17;
        RotationInvariantLocalBinaryPatterns.binTranslate[39] = 18;
        RotationInvariantLocalBinaryPatterns.binTranslate[43] = 19;
        RotationInvariantLocalBinaryPatterns.binTranslate[45] = 20;
        RotationInvariantLocalBinaryPatterns.binTranslate[47] = 21;
        RotationInvariantLocalBinaryPatterns.binTranslate[51] = 22;
        RotationInvariantLocalBinaryPatterns.binTranslate[53] = 23;
        RotationInvariantLocalBinaryPatterns.binTranslate[55] = 24;
        RotationInvariantLocalBinaryPatterns.binTranslate[59] = 25;
        RotationInvariantLocalBinaryPatterns.binTranslate[61] = 26;
        RotationInvariantLocalBinaryPatterns.binTranslate[63] = 27;
        RotationInvariantLocalBinaryPatterns.binTranslate[85] = 28;
        RotationInvariantLocalBinaryPatterns.binTranslate[87] = 29;
        RotationInvariantLocalBinaryPatterns.binTranslate[91] = 30;
        RotationInvariantLocalBinaryPatterns.binTranslate[95] = 31;
        RotationInvariantLocalBinaryPatterns.binTranslate[111] = 32;
        RotationInvariantLocalBinaryPatterns.binTranslate[119] = 33;
        RotationInvariantLocalBinaryPatterns.binTranslate[127] = 34;
        RotationInvariantLocalBinaryPatterns.binTranslate[255] = 35;
    }
}

