/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mpeg7;

import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.StringTokenizer;
import net.semanticmetadata.lire.imageanalysis.LireFeature;
import net.semanticmetadata.lire.utils.ImageUtils;

public class EdgeHistogramImplementation {
    public static final int BIN_COUNT = 80;
    private int[] bins = new int[80];
    private int treshold = 11;
    private double width;
    private double height;
    private int num_block = 1100;
    private static final int NoEdge = 0;
    private static final int vertical_edge = 1;
    private static final int horizontal_edge = 2;
    private static final int non_directional_edge = 3;
    private static final int diagonal_45_degree_edge = 4;
    private static final int diagonal_135_degree_edge = 5;
    private double[][] grey_level;
    private static double[][] QuantTable = new double[][]{{0.010867, 0.057915, 0.099526, 0.144849, 0.195573, 0.260504, 0.358031, 0.530128}, {0.012266, 0.069934, 0.125879, 0.182307, 0.243396, 0.314563, 0.411728, 0.564319}, {0.004193, 0.025852, 0.04686, 0.068519, 0.093286, 0.12349, 0.161505, 0.22896}, {0.004174, 0.025924, 0.046232, 0.067163, 0.089655, 0.115391, 0.151904, 0.217745}, {0.006778, 0.051667, 0.10865, 0.166257, 0.224226, 0.285691, 0.356375, 0.450972}};
    private double[] Local_Edge_Histogram = new double[80];
    private int blockSize = -1;
    private BufferedImage image;
    protected int[] edgeHistogram = new int[80];

    public EdgeHistogramImplementation(BufferedImage image) {
        this.image = image;
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.extractFeature();
        this.edgeHistogram = this.setEdgeHistogram();
    }

    public void extract(BufferedImage image) {
        this.bins = new int[80];
        this.treshold = 11;
        this.num_block = 1100;
        this.Local_Edge_Histogram = new double[80];
        this.blockSize = -1;
        this.image = ImageUtils.get8BitRGBImage(image);
        this.width = image.getWidth();
        this.height = image.getHeight();
        this.extractFeature();
        this.edgeHistogram = this.setEdgeHistogram();
    }

    public EdgeHistogramImplementation(String descriptor) {
        this.setStringRepresentation(descriptor);
    }

    public EdgeHistogramImplementation() {
        this.bins = new int[80];
        this.treshold = 11;
        this.num_block = 1100;
        this.Local_Edge_Histogram = new double[80];
        this.blockSize = -1;
    }

    private void setBinCounts(int[] bins) throws Exception {
        for (int i = 0; i <= 79; ++i) {
            this.bins[i] = bins[i];
        }
    }

    public void setBinCounts(int pos, int[] value) throws ArrayIndexOutOfBoundsException {
        this.bins[pos] = value[pos];
    }

    public int getBinCounts() throws Exception {
        int i = 0;
        return this.bins[i];
    }

    public void setThreshold() {
        this.treshold = 11;
    }

    public int getThreshold() {
        return this.treshold;
    }

    private int getBlockSize() {
        if (this.blockSize < 0) {
            double a = (int)Math.sqrt(this.width * this.height / (double)this.num_block);
            this.blockSize = (int)(Math.floor(a / 2.0) * 2.0);
            if (this.blockSize == 0) {
                this.blockSize = 2;
            }
        }
        return this.blockSize;
    }

    public void makeGreyLevel() {
        this.grey_level = new double[(int)this.width][(int)this.height];
        int x = 0;
        while ((double)x < this.width) {
            int y = 0;
            while ((double)y < this.height) {
                this.grey_level[x][y] = EdgeHistogramImplementation.getYfromRGB(this.image.getRGB(x, y));
                ++y;
            }
            ++x;
        }
    }

    private double getFirstBlockAVG(int i, int j) {
        double average_brightness = 0.0;
        if (this.grey_level[i][j] != 0.0) {
            for (int m = 0; m <= (this.getBlockSize() >> 1) - 1; ++m) {
                for (int n = 0; n <= (this.getBlockSize() >> 1) - 1; ++n) {
                    average_brightness += this.grey_level[i + m][j + n];
                }
            }
        } else {
            System.err.println("Grey level not initialized.");
        }
        double bs = this.getBlockSize() * this.getBlockSize();
        double div = 4.0 / bs;
        return average_brightness *= div;
    }

    private double getSecondBlockAVG(int i, int j) {
        double average_brightness = 0.0;
        if (this.grey_level[i][j] != 0.0) {
            for (int m = this.getBlockSize() >> 1; m <= this.getBlockSize() - 1; ++m) {
                for (int n = 0; n <= (this.getBlockSize() >> 1) - 1; ++n) {
                    average_brightness += this.grey_level[i + m][j + n];
                }
            }
        } else {
            System.err.println("Grey level not initialized.");
        }
        double bs = this.getBlockSize() * this.getBlockSize();
        double div = 4.0 / bs;
        return average_brightness *= div;
    }

    private double getThirdBlockAVG(int i, int j) {
        double average_brightness = 0.0;
        if (this.grey_level[i][j] != 0.0) {
            for (int m = 0; m <= (this.getBlockSize() >> 1) - 1; ++m) {
                for (int n = this.getBlockSize() >> 1; n <= this.getBlockSize() - 1; ++n) {
                    average_brightness += this.grey_level[i + m][j + n];
                }
            }
        } else {
            System.err.println("Grey level not initialized.");
        }
        double bs = this.getBlockSize() * this.getBlockSize();
        double div = 4.0 / bs;
        return average_brightness *= div;
    }

    private double getFourthBlockAVG(int i, int j) {
        double average_brightness = 0.0;
        for (int m = this.getBlockSize() >> 1; m <= this.getBlockSize() - 1; ++m) {
            for (int n = this.getBlockSize() >> 1; n <= this.getBlockSize() - 1; ++n) {
                average_brightness += this.grey_level[i + m][j + n];
            }
        }
        double bs = this.getBlockSize() * this.getBlockSize();
        double div = 4.0 / bs;
        return average_brightness *= div;
    }

    private int getEdgeFeature(int i, int j) {
        double[] average = new double[]{this.getFirstBlockAVG(i, j), this.getSecondBlockAVG(i, j), this.getThirdBlockAVG(i, j), this.getFourthBlockAVG(i, j)};
        double th = this.treshold;
        double[][] edge_filter = new double[][]{{1.0, -1.0, 1.0, -1.0}, {1.0, 1.0, -1.0, -1.0}, {Math.sqrt(2.0), 0.0, 0.0, -Math.sqrt(2.0)}, {0.0, Math.sqrt(2.0), -Math.sqrt(2.0), 0.0}, {2.0, -2.0, -2.0, 2.0}};
        double[] strengths = new double[5];
        for (int e = 0; e < 5; ++e) {
            for (int k = 0; k < 4; ++k) {
                int n = e;
                strengths[n] = strengths[n] + average[k] * edge_filter[e][k];
            }
            strengths[e] = Math.abs(strengths[e]);
        }
        double e_max = 0.0;
        e_max = strengths[0];
        int e_index = 1;
        if (strengths[1] > e_max) {
            e_max = strengths[1];
            e_index = 2;
        }
        if (strengths[2] > e_max) {
            e_max = strengths[2];
            e_index = 4;
        }
        if (strengths[3] > e_max) {
            e_max = strengths[3];
            e_index = 5;
        }
        if (strengths[4] > e_max) {
            e_max = strengths[4];
            e_index = 3;
        }
        if (e_max < th) {
            e_index = 0;
        }
        return e_index;
    }

    public void extractFeature() {
        Arrays.fill(this.Local_Edge_Histogram, 0.0);
        this.makeGreyLevel();
        int sub_local_index = 0;
        int EdgeTypeOfBlock = 0;
        int[] count_local = new int[16];
        for (int i = 0; i < 16; ++i) {
            count_local[i] = 0;
        }
        int j = 0;
        while ((double)j <= this.height - (double)this.getBlockSize()) {
            int i = 0;
            while ((double)i <= this.width - (double)this.getBlockSize()) {
                int n = sub_local_index = (int)((double)(i << 2) / this.width) + ((int)((double)(j << 2) / this.height) << 2);
                count_local[n] = count_local[n] + 1;
                EdgeTypeOfBlock = this.getEdgeFeature(i, j);
                switch (EdgeTypeOfBlock) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        int n2 = sub_local_index * 5;
                        this.Local_Edge_Histogram[n2] = this.Local_Edge_Histogram[n2] + 1.0;
                        break;
                    }
                    case 2: {
                        int n3 = sub_local_index * 5 + 1;
                        this.Local_Edge_Histogram[n3] = this.Local_Edge_Histogram[n3] + 1.0;
                        break;
                    }
                    case 4: {
                        int n4 = sub_local_index * 5 + 2;
                        this.Local_Edge_Histogram[n4] = this.Local_Edge_Histogram[n4] + 1.0;
                        break;
                    }
                    case 5: {
                        int n5 = sub_local_index * 5 + 3;
                        this.Local_Edge_Histogram[n5] = this.Local_Edge_Histogram[n5] + 1.0;
                        break;
                    }
                    case 3: {
                        int n6 = sub_local_index * 5 + 4;
                        this.Local_Edge_Histogram[n6] = this.Local_Edge_Histogram[n6] + 1.0;
                    }
                }
                i += this.getBlockSize();
            }
            j += this.getBlockSize();
        }
        for (int k = 0; k < 80; ++k) {
            int n = k;
            this.Local_Edge_Histogram[n] = this.Local_Edge_Histogram[n] / (double)count_local[k / 5];
        }
    }

    public int[] setEdgeHistogram() {
        int[] Edge_HistogramElement = new int[80];
        double iQuantValue = 0.0;
        double[] value = this.Local_Edge_Histogram;
        block0: for (int i = 0; i < 80; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.bins[i] = j;
                iQuantValue = j < 7 ? (QuantTable[i % 5][j] + QuantTable[i % 5][j + 1]) / 2.0 : 1.0;
                if (value[i] <= iQuantValue) continue block0;
            }
        }
        return this.bins;
    }

    public static float calculateDistance(int[] edgeHistogramA, int[] edgeHistogramB) {
        int i;
        double result = 0.0;
        for (i = 0; i < edgeHistogramA.length; ++i) {
            result += Math.abs(QuantTable[i % 5][edgeHistogramA[i]] - QuantTable[i % 5][edgeHistogramB[i]]);
        }
        for (i = 0; i <= 4; ++i) {
            result += 5.0 * (double)Math.abs(edgeHistogramA[i] - edgeHistogramB[i]);
        }
        for (i = 5; i < 80; ++i) {
            result += (double)Math.abs(edgeHistogramA[i] - edgeHistogramB[i]);
        }
        return (float)result;
    }

    private static int[] RGB2YCRCB(int[] pixel, int[] result) {
        double yy = (0.299 * (double)pixel[0] + 0.587 * (double)pixel[1] + 0.114 * (double)pixel[2]) / 256.0;
        result[0] = (int)(219.0 * yy + 16.5);
        result[1] = (int)(126.33599999999998 * ((double)pixel[2] / 256.0 * 1.0 - yy) + 128.5);
        result[2] = (int)(159.712 * ((double)pixel[0] / 256.0 * 1.0 - yy) + 128.5);
        return result;
    }

    private static int getYfromRGB(int rgb) {
        int b = rgb & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int r = rgb >> 16 & 0xFF;
        double yy = (0.299 * (double)r + 0.587 * (double)g + 0.114 * (double)b) / 256.0;
        return (int)(219.0 * yy + 16.5);
    }

    public float getDistance(LireFeature descriptor) {
        if (!(descriptor instanceof EdgeHistogramImplementation)) {
            return -1.0f;
        }
        EdgeHistogramImplementation e = (EdgeHistogramImplementation)((Object)descriptor);
        return EdgeHistogramImplementation.calculateDistance(e.edgeHistogram, this.edgeHistogram);
    }

    public String getStringRepresentation() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("edgehistogram;");
        stringBuilder.append(this.edgeHistogram[0]);
        for (int i = 1; i < this.edgeHistogram.length; ++i) {
            stringBuilder.append(' ');
            stringBuilder.append(this.edgeHistogram[i]);
        }
        return stringBuilder.toString();
    }

    public void setStringRepresentation(String descriptor) {
        String[] parts = descriptor.split(";");
        if (!parts[0].equals("edgehistogram")) {
            throw new UnsupportedOperationException("This is no valid representation of a EdgeHistogram descriptor!");
        }
        int[] bins = new int[80];
        StringTokenizer st = new StringTokenizer(parts[1], " ");
        int count = 0;
        while (st.hasMoreElements()) {
            bins[count] = Integer.parseInt(st.nextToken());
            ++count;
        }
        this.edgeHistogram = bins;
    }
}

