/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mser.fourier;

import java.awt.geom.Point2D;
import net.semanticmetadata.lire.imageanalysis.mser.fourier.utils.Complex;
import net.semanticmetadata.lire.imageanalysis.mser.fourier.utils.PolygonUtils;

public class Fourier {
    double[] c;
    double[] d;
    Complex[] a;
    Complex[] b;
    Complex[] Q;
    double[] t;
    Point2D.Double[] points;
    int NPT;

    public Fourier(Point2D.Double[] points) {
        this.points = points;
        this.NPT = points.length - 1;
        this.t = Fourier.calcParameter(points, 2);
    }

    public void computeFourier(int kmax) {
        this.a = new Complex[kmax + 1];
        this.b = new Complex[kmax + 1];
        double PER = this.t[this.NPT] - this.t[0];
        for (int k = 0; k <= kmax; ++k) {
            if (k == 0) {
                double sumX = 0.0;
                double sumY = 0.0;
                for (int i = 0; i < this.NPT; ++i) {
                    double factor = this.t[i + 1] - this.t[i];
                    sumX += (this.points[i + 1].x + this.points[i].x) * factor;
                    sumY += (this.points[i + 1].y + this.points[i].y) * factor;
                }
                this.a[k] = new Complex(sumX / (2.0 * PER), sumY / (2.0 * PER));
                this.b[k] = new Complex(0.0, 0.0);
                continue;
            }
            double ZP = 6.28318530718;
            double A0 = PER / (ZP * ZP);
            double B0 = 1.0 / ZP;
            double P0 = ZP / PER;
            double XK = 1.0 * (double)k;
            double PK = P0 * XK;
            double PH = PK * this.t[0];
            Complex E1P = new Complex(Math.cos(PH), -Math.sin(PH));
            Complex E1M = E1P.conjugate();
            Complex AP = new Complex(0.0, 0.0);
            Complex BP = new Complex(0.0, 0.0);
            Complex AM = new Complex(0.0, 0.0);
            Complex BM = new Complex(0.0, 0.0);
            for (int i = 0; i < this.NPT; ++i) {
                Complex DX = new Complex(this.points[(i + 1) % this.NPT].x - this.points[i].x, this.points[(i + 1) % this.NPT].y - this.points[i].y);
                Complex DT = new Complex(this.t[i + 1] - this.t[i], 0.0);
                if (DT.re() == 0.0) {
                    BP = BP.plus(DX.times(E1P));
                    BM = BM.plus(DX.times(E1M));
                } else {
                    PH = PK * this.t[i + 1];
                    Complex E0P = E1P;
                    Complex E0M = E1M;
                    E1P = new Complex(Math.cos(PH), -Math.sin(PH));
                    E1M = E1P.conjugate();
                    DX = DX.divides(DT);
                    AP = AP.plus(DX.times(E1P.minus(E0P)));
                    AM = AM.plus(DX.times(E1M.minus(E0M)));
                }
                this.a[k] = AP.times(A0 / (XK * XK)).minus(new Complex(0.0, B0 / XK).times(BP));
                this.b[k] = AM.times(A0 / (XK * XK)).plus(new Complex(0.0, B0 / XK).times(BM));
            }
        }
    }

    public static double[] calcParameter(Point2D.Double[] polygon, int type) {
        int N = polygon.length;
        double[] t = new double[N];
        t[0] = 0.0;
        switch (type) {
            case 1: {
                Complex x = new Complex(polygon[0].x, polygon[0].y);
                for (int i = 0; i < N - 1; ++i) {
                    Complex x1 = new Complex(polygon[i + 1].x, polygon[i + 1].y);
                    Complex dx = x1.minus(x);
                    double d = Math.sqrt(dx.times(dx.conjugate()).re());
                    t[i + 1] = t[i] + d;
                    x = x1;
                }
                break;
            }
            case 2: 
            case 3: {
                double factor = 0.0;
                for (int i = 1; i < N; ++i) {
                    int j = i - 1;
                    factor = polygon[j].x * polygon[i].y - polygon[i].x * polygon[j].y;
                    factor = factor > 0.0 ? factor : 0.0 - factor;
                    t[i] = type == 2 ? t[i - 1] + Math.abs(factor / 2.0) : t[i - 1] + factor / 2.0;
                }
                break;
            }
        }
        return t;
    }

    public static void main(String[] args) {
        Point2D.Double[] EF = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(1.0, 0.0), new Point2D.Double(1.0, 2.5), new Point2D.Double(2.5, 2.5), new Point2D.Double(2.5, 3.5), new Point2D.Double(1.0, 3.5), new Point2D.Double(1.0, 4.5), new Point2D.Double(3.5, 4.5), new Point2D.Double(3.5, 5.5), new Point2D.Double(0.0, 5.5), new Point2D.Double(0.0, 0.0)};
        Fourier.testFourier(EF, 5);
        Point2D.Double[] EF2 = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(1.0, 0.0), new Point2D.Double(1.0, 2.5), new Point2D.Double(2.5, 2.5), new Point2D.Double(2.5, 3.5), new Point2D.Double(1.0, 3.5), new Point2D.Double(1.0, 4.5), new Point2D.Double(3.5, 4.5), new Point2D.Double(2.5, 5.5), new Point2D.Double(0.0, 5.5), new Point2D.Double(0.0, 0.0)};
        Fourier.testFourier(EF2, 5);
        EF = new Point2D.Double[]{new Point2D.Double(0.0, 0.0), new Point2D.Double(1.0, 0.0), new Point2D.Double(1.0, 2.5), new Point2D.Double(2.5, 2.5), new Point2D.Double(2.5, 3.5), new Point2D.Double(1.0, 3.5), new Point2D.Double(1.0, 4.5), new Point2D.Double(3.5, 4.5), new Point2D.Double(3.5, 5.5), new Point2D.Double(0.0, 5.5), new Point2D.Double(0.0, 0.0)};
        double[][] A = new double[][]{{3.0, 1.0}, {2.0, 3.0}};
        Point2D.Double[] EF3 = Fourier.matMult(A, EF);
        Fourier.testFourier(EF3, 5);
        EF = new Point2D.Double[]{new Point2D.Double(1.0, 2.5), new Point2D.Double(2.5, 2.5), new Point2D.Double(2.5, 3.5), new Point2D.Double(1.0, 3.5), new Point2D.Double(1.0, 4.5), new Point2D.Double(3.5, 4.5), new Point2D.Double(3.5, 5.5), new Point2D.Double(0.0, 5.5), new Point2D.Double(0.0, 0.0), new Point2D.Double(1.0, 0.0), new Point2D.Double(1.0, 2.5)};
        EF3 = Fourier.matMult(A, EF);
        Fourier.testFourier(EF3, 5);
    }

    protected static Point2D.Double[] matMult(double[][] A, Point2D.Double[] points) {
        double a11 = A[0][0];
        double a12 = A[1][0];
        double a21 = A[0][1];
        double a22 = A[1][1];
        Point2D.Double[] result = new Point2D.Double[points.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new Point2D.Double(a11 * points[i].x + a12 * points[i].y, a21 * points[i].x + a22 * points[i].y);
        }
        return result;
    }

    protected static void testFourier(Point2D.Double[] poly, int k) {
        Fourier.printPoints(poly);
        Point2D.Double cog = PolygonUtils.polygonCenterOfMass(poly);
        PolygonUtils.applyCoG(poly, cog);
        Fourier.printPoints(poly);
        cog = PolygonUtils.polygonCenterOfMass(poly);
        double[] t = Fourier.calcParameter(poly, 2);
        Fourier.printParametrisierung(t);
        Fourier f = new Fourier(poly);
        f.computeFourier(k);
        f.printCoefficients();
        f.createInvariants2(1);
        f.printInvariants();
    }

    public static void printPoints(Point2D.Double[] points) {
        int i;
        for (i = 0; i < points.length; ++i) {
        }
        for (i = 0; i < points.length; ++i) {
        }
    }

    public static void printParametrisierung(double[] t) {
        for (int i = 0; i < t.length; ++i) {
        }
    }

    public void printCoefficients() {
        int i;
        for (i = this.b.length - 1; i > 0; --i) {
        }
        for (i = 0; i < this.a.length; ++i) {
        }
    }

    public void createInvariants2(int s) {
        int i;
        int q = 1;
        int l = this.a.length + this.b.length - 1;
        this.a[0] = new Complex(0.0, 0.0);
        this.b[0] = new Complex(0.0, 0.0);
        Complex[] fd = new Complex[this.a.length + this.b.length - 1];
        this.createInvariants(s);
        this.c = new double[this.a.length];
        this.d = new double[this.a.length];
        for (int i2 = 0; i2 < this.a.length; ++i2) {
            this.c[i2] = this.a[i2].abs() / this.a[q].abs();
            this.d[i2] = this.b[i2].abs() / this.a[q].abs();
        }
        int n = this.a.length - 1;
        int[] N = new int[l];
        for (int i3 = 0; i3 < N.length; ++i3) {
            N[i3] = i3 - n;
        }
        double[] phi = new double[l];
        int counter = 0;
        for (i = this.b.length - 1; i > 0; --i) {
            phi[counter++] = this.getArg(this.b[i]);
        }
        phi[counter++] = 0.0;
        for (i = 1; i < this.a.length; ++i) {
            phi[counter++] = this.getArg(this.a[i]);
        }
        for (i = 0; i < phi.length; ++i) {
        }
        for (i = 0; i < phi.length; ++i) {
            phi[i] = phi[i] + (double)((q - N[i]) / s) * this.getArg(this.a[q + s]);
        }
        for (i = 0; i < phi.length; ++i) {
        }
        for (i = 0; i < phi.length; ++i) {
            phi[i] = phi[i] - (double)((q + s - N[i]) / s) * this.getArg(this.a[q]);
        }
        for (i = 0; i < phi.length; ++i) {
        }
        for (i = 0; i < this.c.length; ++i) {
            fd[i] = new Complex(this.d[this.d.length - i - 1], 0.0).times(new Complex(0.0, phi[i]).exp());
            fd[n + i] = new Complex(this.c[i], 0.0).times(new Complex(0.0, phi[n + i]).exp());
        }
        for (i = 0; i < fd.length; ++i) {
        }
        for (i = 0; i < this.c.length; ++i) {
            this.d[this.d.length - i - 1] = fd[i].abs();
            this.c[i] = fd[n + i].abs();
        }
    }

    public void createInvariants(int s) {
        Complex Det = new Complex(0.0, 0.0);
        Complex UpStar = new Complex(0.0, 0.0);
        Complex VpStar = new Complex(0.0, 0.0);
        int p = 0;
        for (int i = 1; i < this.a.length; ++i) {
            Complex curUp = this.a[i].plus(this.b[i].conjugate()).divides(new Complex(2.0, 0.0));
            Complex curUpStar = curUp.conjugate();
            Complex curVp = this.a[i].minus(this.b[i].conjugate()).divides(new Complex(0.0, 2.0));
            Complex curVpStar = curVp.conjugate();
            Complex curDet = curUp.times(curVpStar).minus(curVp.times(curUpStar));
            if (!(curDet.abs() > Det.abs())) continue;
            p = i;
            UpStar = curUpStar;
            VpStar = curVpStar;
            Det = curDet;
        }
        this.Q = new Complex[this.a.length];
        for (int i = 1; i < this.a.length; ++i) {
            Complex U = this.a[i].plus(this.b[i].conjugate()).divides(new Complex(2.0, 0.0));
            Complex V = this.a[i].minus(this.b[i].conjugate()).divides(new Complex(0.0, 2.0));
            this.Q[i] = U.times(VpStar).minus(V.times(UpStar)).divides(Det);
            this.a[i] = this.Q[i];
            this.Q[i] = U.conjugate().times(VpStar).minus(V.conjugate().times(UpStar)).divides(Det);
            this.b[i] = this.Q[i];
        }
        this.a[0] = new Complex(0.0, 0.0);
        this.b[0] = new Complex(0.0, 0.0);
    }

    protected Complex calcPower(Complex number, int factor) {
        Complex powered;
        if (factor == 0) {
            powered = new Complex(1.0, 0.0);
        } else {
            if (factor > 0) {
                Complex powered2 = number;
                for (int i = 1; i < factor; ++i) {
                    powered2 = powered2.times(number);
                }
                return powered2;
            }
            powered = this.calcPower(number, 0 - factor);
            powered = new Complex(1.0, 0.0).divides(powered);
        }
        return powered;
    }

    public void printInvariants() {
        int i;
        for (i = this.d.length - 1; i > 0; --i) {
        }
        for (i = 0; i < this.c.length; ++i) {
        }
    }

    public double getArg(Complex c) {
        return Math.atan2(c.im(), c.re());
    }

    public float[] getInvariants() {
        int i;
        float[] result = new float[this.d.length * 2 - 1];
        int counter = 0;
        for (i = this.d.length - 1; i > 0; --i) {
            result[counter++] = (float)this.d[i];
        }
        for (i = 0; i < this.c.length; ++i) {
            result[counter++] = (float)this.c[i];
        }
        return result;
    }
}

