/*
 * Decompiled with CFR 0.152.
 */
package net.semanticmetadata.lire.imageanalysis.mser.fourier.utils;

import java.awt.geom.Point2D;

public class PolygonUtils {
    public static double signedPolygonArea(Point2D.Double[] polygon) {
        int N = polygon.length;
        double area = 0.0;
        for (int i = 0; i < N; ++i) {
            int j = (i + 1) % N;
            area += polygon[i].x * polygon[j].y;
            area -= polygon[i].y * polygon[j].x;
        }
        return area /= 2.0;
    }

    public static double unsignedPolygonArea(Point2D.Double[] polygon) {
        double area = PolygonUtils.signedPolygonArea(polygon);
        return area < 0.0 ? -area : area;
    }

    public static Point2D.Double polygonCenterOfMass(Point2D.Double[] polygon) {
        int N = polygon.length - 1;
        double cx = 0.0;
        double cy = 0.0;
        Point2D.Double res = new Point2D.Double();
        double sumDet = 0.0;
        double factor = 0.0;
        for (int i = 0; i < N; ++i) {
            int j = i + 1;
            factor = polygon[i].x * polygon[j].y - polygon[j].x * polygon[i].y;
            cx += (polygon[i].x + polygon[j].x) * factor;
            cy += (polygon[i].y + polygon[j].y) * factor;
            sumDet += factor;
        }
        factor = 1.0 / (3.0 * sumDet);
        res.x = cx *= factor;
        res.y = cy *= factor;
        return res;
    }

    public static void applyCoG(Point2D.Double[] points, Point2D.Double cog) {
        for (int i = 0; i < points.length; ++i) {
            points[i].setLocation(points[i].x - cog.x, points[i].y - cog.y);
        }
    }

    public static void main(String[] args) {
        Point2D.Double[] test = new Point2D.Double[]{new Point2D.Double(-1.0, -4.0), new Point2D.Double(-4.0, 2.0), new Point2D.Double(-1.0, 5.0), new Point2D.Double(2.0, 2.0)};
        Point2D.Double cog = PolygonUtils.polygonCenterOfMass(test);
        System.out.println(((Point2D)cog).getX() + "/" + ((Point2D)cog).getY());
        Point2D.Double[] test2 = new Point2D.Double[]{new Point2D.Double(1.0, 2.0), new Point2D.Double(4.0, 2.0), new Point2D.Double(5.0, 3.0), new Point2D.Double(2.0, 3.0)};
        cog = PolygonUtils.polygonCenterOfMass(test2);
        System.out.println(((Point2D)cog).getX() + "/" + ((Point2D)cog).getY());
    }
}

